// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Allows you to take control over the process of converting text into indexable/searchable tokens. It's a user-defined
 * configuration consisting of a single predefined tokenizer and one or more filters. The tokenizer is responsible for
 * breaking text into tokens, and the filters for modifying tokens emitted by the tokenizer.
 */
@Fluent
public final class CustomAnalyzer extends LexicalAnalyzer {

    /*
     * The name of the tokenizer to use to divide continuous text into a sequence of tokens, such as breaking a
     * sentence into words.
     */
    private final LexicalTokenizerName tokenizer;

    /*
     * A list of token filters used to filter out or modify the tokens generated by a tokenizer. For example, you can
     * specify a lowercase filter that converts all characters to lowercase. The filters are run in the order in which
     * they are listed.
     */
    private List<TokenFilterName> tokenFilters;

    /*
     * A list of character filters used to prepare input text before it is processed by the tokenizer. For instance,
     * they can replace certain characters or symbols. The filters are run in the order in which they are listed.
     */
    private List<CharFilterName> charFilters;

    /**
     * Creates an instance of CustomAnalyzer class.
     *
     * @param name the name value to set.
     * @param tokenizer the tokenizer value to set.
     */
    public CustomAnalyzer(String name, LexicalTokenizerName tokenizer) {
        super(name);
        this.tokenizer = tokenizer;
    }

    /**
     * Get the tokenizer property: The name of the tokenizer to use to divide continuous text into a sequence of tokens,
     * such as breaking a sentence into words.
     *
     * @return the tokenizer value.
     */
    public LexicalTokenizerName getTokenizer() {
        return this.tokenizer;
    }

    /**
     * Get the tokenFilters property: A list of token filters used to filter out or modify the tokens generated by a
     * tokenizer. For example, you can specify a lowercase filter that converts all characters to lowercase. The filters
     * are run in the order in which they are listed.
     *
     * @return the tokenFilters value.
     */
    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    /**
     * Set the tokenFilters property: A list of token filters used to filter out or modify the tokens generated by a
     * tokenizer. For example, you can specify a lowercase filter that converts all characters to lowercase. The filters
     * are run in the order in which they are listed.
     *
     * @param tokenFilters the tokenFilters value to set.
     * @return the CustomAnalyzer object itself.
     */
    public CustomAnalyzer setTokenFilters(List<TokenFilterName> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    /**
     * Get the charFilters property: A list of character filters used to prepare input text before it is processed by
     * the tokenizer. For instance, they can replace certain characters or symbols. The filters are run in the order in
     * which they are listed.
     *
     * @return the charFilters value.
     */
    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    /**
     * Set the charFilters property: A list of character filters used to prepare input text before it is processed by
     * the tokenizer. For instance, they can replace certain characters or symbols. The filters are run in the order in
     * which they are listed.
     *
     * @param charFilters the charFilters value to set.
     * @return the CustomAnalyzer object itself.
     */
    public CustomAnalyzer setCharFilters(List<CharFilterName> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.CustomAnalyzer");
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("tokenizer", Objects.toString(this.tokenizer, null));
        jsonWriter.writeArrayField(
                "tokenFilters",
                this.tokenFilters,
                (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeArrayField(
                "charFilters",
                this.charFilters,
                (writer, element) -> writer.writeString(Objects.toString(element, null)));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomAnalyzer from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomAnalyzer if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties or the
     *     polymorphic discriminator.
     * @throws IOException If an error occurs while reading the CustomAnalyzer.
     */
    public static CustomAnalyzer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean nameFound = false;
                    String name = null;
                    boolean tokenizerFound = false;
                    LexicalTokenizerName tokenizer = null;
                    List<TokenFilterName> tokenFilters = null;
                    List<CharFilterName> charFilters = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("@odata.type".equals(fieldName)) {
                            String odataType = reader.getString();
                            if (!"#Microsoft.Azure.Search.CustomAnalyzer".equals(odataType)) {
                                throw new IllegalStateException(
                                        "'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.CustomAnalyzer'. The found '@odata.type' was '"
                                                + odataType
                                                + "'.");
                            }
                        } else if ("name".equals(fieldName)) {
                            name = reader.getString();
                            nameFound = true;
                        } else if ("tokenizer".equals(fieldName)) {
                            tokenizer = LexicalTokenizerName.fromString(reader.getString());
                            tokenizerFound = true;
                        } else if ("tokenFilters".equals(fieldName)) {
                            tokenFilters = reader.readArray(reader1 -> TokenFilterName.fromString(reader1.getString()));
                        } else if ("charFilters".equals(fieldName)) {
                            charFilters = reader.readArray(reader1 -> CharFilterName.fromString(reader1.getString()));
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (nameFound && tokenizerFound) {
                        CustomAnalyzer deserializedCustomAnalyzer = new CustomAnalyzer(name, tokenizer);
                        deserializedCustomAnalyzer.tokenFilters = tokenFilters;
                        deserializedCustomAnalyzer.charFilters = charFilters;
                        return deserializedCustomAnalyzer;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!nameFound) {
                        missingProperties.add("name");
                    }
                    if (!tokenizerFound) {
                        missingProperties.add("tokenizer");
                    }
                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }

    /**
     * Set the tokenFilters property: A list of token filters used to filter out or modify the tokens generated by a
     * tokenizer. For example, you can specify a lowercase filter that converts all characters to lowercase. The filters
     * are run in the order in which they are listed.
     *
     * @param tokenFilters the tokenFilters value to set.
     * @return the CustomAnalyzer object itself.
     */
    public CustomAnalyzer setTokenFilters(TokenFilterName... tokenFilters) {
        this.tokenFilters = (tokenFilters == null) ? null : java.util.Arrays.asList(tokenFilters);
        return this;
    }

    /**
     * Set the charFilters property: A list of character filters used to prepare input text before it is processed by
     * the tokenizer. For instance, they can replace certain characters or symbols. The filters are run in the order in
     * which they are listed.
     *
     * @param charFilters the charFilters value to set.
     * @return the CustomAnalyzer object itself.
     */
    public CustomAnalyzer setCharFilters(CharFilterName... charFilters) {
        this.charFilters = (charFilters == null) ? null : java.util.Arrays.asList(charFilters);
        return this;
    }
}
