// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** Base type for data change detection policies. */
@Immutable
public abstract class DataChangeDetectionPolicy implements JsonSerializable<DataChangeDetectionPolicy> {
    /** Creates an instance of DataChangeDetectionPolicy class. */
    public DataChangeDetectionPolicy() {}

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataChangeDetectionPolicy from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataChangeDetectionPolicy if the JsonReader was pointing to an instance of it, or null if
     *     it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing the polymorphic discriminator.
     * @throws IOException If an error occurs while reading the DataChangeDetectionPolicy.
     */
    public static DataChangeDetectionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    String discriminatorValue = null;
                    JsonReader readerToUse = reader.bufferObject();

                    readerToUse.nextToken(); // Prepare for reading
                    while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = readerToUse.getFieldName();
                        readerToUse.nextToken();
                        if ("@odata.type".equals(fieldName)) {
                            discriminatorValue = readerToUse.getString();
                            break;
                        } else {
                            readerToUse.skipChildren();
                        }
                    }

                    if (discriminatorValue != null) {
                        readerToUse = readerToUse.reset();
                    }
                    // Use the discriminator value to determine which subtype should be deserialized.
                    if ("#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy".equals(discriminatorValue)) {
                        return HighWaterMarkChangeDetectionPolicy.fromJson(readerToUse);
                    } else if ("#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy".equals(discriminatorValue)) {
                        return SqlIntegratedChangeTrackingPolicy.fromJson(readerToUse);
                    } else {
                        throw new IllegalStateException(
                                "Discriminator field '@odata.type' didn't match one of the expected values '#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy', or '#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy'. It was: '"
                                        + discriminatorValue
                                        + "'.");
                    }
                });
    }
}
