// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/** Defines a data change detection policy that captures changes based on the value of a high water mark column. */
@Immutable
public final class HighWaterMarkChangeDetectionPolicy extends DataChangeDetectionPolicy {
    /*
     * The name of the high water mark column.
     */
    private final String highWaterMarkColumnName;

    /**
     * Creates an instance of HighWaterMarkChangeDetectionPolicy class.
     *
     * @param highWaterMarkColumnName the highWaterMarkColumnName value to set.
     */
    public HighWaterMarkChangeDetectionPolicy(String highWaterMarkColumnName) {
        this.highWaterMarkColumnName = highWaterMarkColumnName;
    }

    /**
     * Get the highWaterMarkColumnName property: The name of the high water mark column.
     *
     * @return the highWaterMarkColumnName value.
     */
    public String getHighWaterMarkColumnName() {
        return this.highWaterMarkColumnName;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy");
        jsonWriter.writeStringField("highWaterMarkColumnName", this.highWaterMarkColumnName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HighWaterMarkChangeDetectionPolicy from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of HighWaterMarkChangeDetectionPolicy if the JsonReader was pointing to an instance of it, or
     *     null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties or the
     *     polymorphic discriminator.
     * @throws IOException If an error occurs while reading the HighWaterMarkChangeDetectionPolicy.
     */
    public static HighWaterMarkChangeDetectionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean highWaterMarkColumnNameFound = false;
                    String highWaterMarkColumnName = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("@odata.type".equals(fieldName)) {
                            String odataType = reader.getString();
                            if (!"#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy".equals(odataType)) {
                                throw new IllegalStateException(
                                        "'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy'. The found '@odata.type' was '"
                                                + odataType
                                                + "'.");
                            }
                        } else if ("highWaterMarkColumnName".equals(fieldName)) {
                            highWaterMarkColumnName = reader.getString();
                            highWaterMarkColumnNameFound = true;
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (highWaterMarkColumnNameFound) {
                        HighWaterMarkChangeDetectionPolicy deserializedHighWaterMarkChangeDetectionPolicy =
                                new HighWaterMarkChangeDetectionPolicy(highWaterMarkColumnName);

                        return deserializedHighWaterMarkChangeDetectionPolicy;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!highWaterMarkColumnNameFound) {
                        missingProperties.add("highWaterMarkColumnName");
                    }

                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }
}
