// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** Specifies the environment in which the indexer should execute. */
public final class IndexerExecutionEnvironment extends ExpandableStringEnum<IndexerExecutionEnvironment> {
    /**
     * Indicates that the search service can determine where the indexer should execute. This is the default environment
     * when nothing is specified and is the recommended value.
     */
    public static final IndexerExecutionEnvironment STANDARD = fromString("standard");

    /**
     * Indicates that the indexer should run with the environment provisioned specifically for the search service. This
     * should only be specified as the execution environment if the indexer needs to access resources securely over
     * shared private link resources.
     */
    public static final IndexerExecutionEnvironment PRIVATE = fromString("private");

    /**
     * Creates a new instance of IndexerExecutionEnvironment value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IndexerExecutionEnvironment() {}

    /**
     * Creates or finds a IndexerExecutionEnvironment from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding IndexerExecutionEnvironment.
     */
    public static IndexerExecutionEnvironment fromString(String name) {
        return fromString(name, IndexerExecutionEnvironment.class);
    }

    /**
     * Gets known IndexerExecutionEnvironment values.
     *
     * @return known IndexerExecutionEnvironment values.
     */
    public static Collection<IndexerExecutionEnvironment> values() {
        return values(IndexerExecutionEnvironment.class);
    }
}
