// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A skill that detects the language of input text and reports a single language code for every document submitted on
 * the request. The language code is paired with a score indicating the confidence of the analysis.
 */
@Fluent
public final class LanguageDetectionSkill extends SearchIndexerSkill {
    /*
     * A country code to use as a hint to the language detection model if it cannot disambiguate the language.
     */
    private String defaultCountryHint;

    /*
     * The version of the model to use when calling the Text Analytics service. It will default to the latest available
     * when not specified. We recommend you do not specify this value unless absolutely necessary.
     */
    private String modelVersion;

    /**
     * Creates an instance of LanguageDetectionSkill class.
     *
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     */
    public LanguageDetectionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    /**
     * Get the defaultCountryHint property: A country code to use as a hint to the language detection model if it cannot
     * disambiguate the language.
     *
     * @return the defaultCountryHint value.
     */
    public String getDefaultCountryHint() {
        return this.defaultCountryHint;
    }

    /**
     * Set the defaultCountryHint property: A country code to use as a hint to the language detection model if it cannot
     * disambiguate the language.
     *
     * @param defaultCountryHint the defaultCountryHint value to set.
     * @return the LanguageDetectionSkill object itself.
     */
    public LanguageDetectionSkill setDefaultCountryHint(String defaultCountryHint) {
        this.defaultCountryHint = defaultCountryHint;
        return this;
    }

    /**
     * Get the modelVersion property: The version of the model to use when calling the Text Analytics service. It will
     * default to the latest available when not specified. We recommend you do not specify this value unless absolutely
     * necessary.
     *
     * @return the modelVersion value.
     */
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * Set the modelVersion property: The version of the model to use when calling the Text Analytics service. It will
     * default to the latest available when not specified. We recommend you do not specify this value unless absolutely
     * necessary.
     *
     * @param modelVersion the modelVersion value to set.
     * @return the LanguageDetectionSkill object itself.
     */
    public LanguageDetectionSkill setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public LanguageDetectionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public LanguageDetectionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public LanguageDetectionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Skills.Text.LanguageDetectionSkill");
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("defaultCountryHint", this.defaultCountryHint);
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LanguageDetectionSkill from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of LanguageDetectionSkill if the JsonReader was pointing to an instance of it, or null if it
     *     was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties or the
     *     polymorphic discriminator.
     * @throws IOException If an error occurs while reading the LanguageDetectionSkill.
     */
    public static LanguageDetectionSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean inputsFound = false;
                    List<InputFieldMappingEntry> inputs = null;
                    boolean outputsFound = false;
                    List<OutputFieldMappingEntry> outputs = null;
                    String name = null;
                    String description = null;
                    String context = null;
                    String defaultCountryHint = null;
                    String modelVersion = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("@odata.type".equals(fieldName)) {
                            String odataType = reader.getString();
                            if (!"#Microsoft.Skills.Text.LanguageDetectionSkill".equals(odataType)) {
                                throw new IllegalStateException(
                                        "'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.LanguageDetectionSkill'. The found '@odata.type' was '"
                                                + odataType
                                                + "'.");
                            }
                        } else if ("inputs".equals(fieldName)) {
                            inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                            inputsFound = true;
                        } else if ("outputs".equals(fieldName)) {
                            outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                            outputsFound = true;
                        } else if ("name".equals(fieldName)) {
                            name = reader.getString();
                        } else if ("description".equals(fieldName)) {
                            description = reader.getString();
                        } else if ("context".equals(fieldName)) {
                            context = reader.getString();
                        } else if ("defaultCountryHint".equals(fieldName)) {
                            defaultCountryHint = reader.getString();
                        } else if ("modelVersion".equals(fieldName)) {
                            modelVersion = reader.getString();
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (inputsFound && outputsFound) {
                        LanguageDetectionSkill deserializedLanguageDetectionSkill =
                                new LanguageDetectionSkill(inputs, outputs);
                        deserializedLanguageDetectionSkill.setName(name);
                        deserializedLanguageDetectionSkill.setDescription(description);
                        deserializedLanguageDetectionSkill.setContext(context);
                        deserializedLanguageDetectionSkill.defaultCountryHint = defaultCountryHint;
                        deserializedLanguageDetectionSkill.modelVersion = modelVersion;

                        return deserializedLanguageDetectionSkill;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!inputsFound) {
                        missingProperties.add("inputs");
                    }
                    if (!outputsFound) {
                        missingProperties.add("outputs");
                    }

                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }
}
