// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/** Provides parameter values to a magnitude scoring function. */
@Fluent
public final class MagnitudeScoringParameters implements JsonSerializable<MagnitudeScoringParameters> {

    /*
     * The field value at which boosting starts.
     */
    private final double boostingRangeStart;

    /*
     * The field value at which boosting ends.
     */
    private final double boostingRangeEnd;

    /*
     * A value indicating whether to apply a constant boost for field values beyond the range end value; default is
     * false.
     */
    private Boolean shouldBoostBeyondRangeByConstant;

    /**
     * Creates an instance of MagnitudeScoringParameters class.
     *
     * @param boostingRangeStart the boostingRangeStart value to set.
     * @param boostingRangeEnd the boostingRangeEnd value to set.
     */
    public MagnitudeScoringParameters(double boostingRangeStart, double boostingRangeEnd) {
        this.boostingRangeStart = boostingRangeStart;
        this.boostingRangeEnd = boostingRangeEnd;
    }

    /**
     * Get the boostingRangeStart property: The field value at which boosting starts.
     *
     * @return the boostingRangeStart value.
     */
    public double getBoostingRangeStart() {
        return this.boostingRangeStart;
    }

    /**
     * Get the boostingRangeEnd property: The field value at which boosting ends.
     *
     * @return the boostingRangeEnd value.
     */
    public double getBoostingRangeEnd() {
        return this.boostingRangeEnd;
    }

    /**
     * Get the shouldBoostBeyondRangeByConstant property: A value indicating whether to apply a constant boost for field
     * values beyond the range end value; default is false.
     *
     * @return the shouldBoostBeyondRangeByConstant value.
     */
    public Boolean shouldBoostBeyondRangeByConstant() {
        return this.shouldBoostBeyondRangeByConstant;
    }

    /**
     * Set the shouldBoostBeyondRangeByConstant property: A value indicating whether to apply a constant boost for field
     * values beyond the range end value; default is false.
     *
     * @param shouldBoostBeyondRangeByConstant the shouldBoostBeyondRangeByConstant value to set.
     * @return the MagnitudeScoringParameters object itself.
     */
    public MagnitudeScoringParameters setShouldBoostBeyondRangeByConstant(Boolean shouldBoostBeyondRangeByConstant) {
        this.shouldBoostBeyondRangeByConstant = shouldBoostBeyondRangeByConstant;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("boostingRangeStart", this.boostingRangeStart);
        jsonWriter.writeDoubleField("boostingRangeEnd", this.boostingRangeEnd);
        jsonWriter.writeBooleanField("constantBoostBeyondRange", this.shouldBoostBeyondRangeByConstant);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MagnitudeScoringParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MagnitudeScoringParameters if the JsonReader was pointing to an instance of it, or null if
     *     it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MagnitudeScoringParameters.
     */
    public static MagnitudeScoringParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean boostingRangeStartFound = false;
                    double boostingRangeStart = 0.0;
                    boolean boostingRangeEndFound = false;
                    double boostingRangeEnd = 0.0;
                    Boolean shouldBoostBeyondRangeByConstant = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("boostingRangeStart".equals(fieldName)) {
                            boostingRangeStart = reader.getDouble();
                            boostingRangeStartFound = true;
                        } else if ("boostingRangeEnd".equals(fieldName)) {
                            boostingRangeEnd = reader.getDouble();
                            boostingRangeEndFound = true;
                        } else if ("constantBoostBeyondRange".equals(fieldName)) {
                            shouldBoostBeyondRangeByConstant = reader.getNullable(JsonReader::getBoolean);
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (boostingRangeStartFound && boostingRangeEndFound) {
                        MagnitudeScoringParameters deserializedMagnitudeScoringParameters =
                                new MagnitudeScoringParameters(boostingRangeStart, boostingRangeEnd);
                        deserializedMagnitudeScoringParameters.shouldBoostBeyondRangeByConstant =
                                shouldBoostBeyondRangeByConstant;
                        return deserializedMagnitudeScoringParameters;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!boostingRangeStartFound) {
                        missingProperties.add("boostingRangeStart");
                    }
                    if (!boostingRangeEndFound) {
                        missingProperties.add("boostingRangeEnd");
                    }
                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }
}
