// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Using the Text Analytics API, extracts personal information from an input text and gives you the option of masking
 * it.
 */
@Fluent
public final class PiiDetectionSkill extends SearchIndexerSkill {
    /*
     * A value indicating which language code to use. Default is `en`.
     */
    private String defaultLanguageCode;

    /*
     * A value between 0 and 1 that be used to only include entities whose confidence score is greater than the value
     * specified. If not set (default), or if explicitly set to null, all entities will be included.
     */
    private Double minimumPrecision;

    /*
     * A parameter that provides various ways to mask the personal information detected in the input text. Default is
     * 'none'.
     */
    private PiiDetectionSkillMaskingMode maskingMode;

    /*
     * The character used to mask the text if the maskingMode parameter is set to replace. Default is `*`.
     */
    private String mask;

    /*
     * The version of the model to use when calling the Text Analytics service. It will default to the latest available
     * when not specified. We recommend you do not specify this value unless absolutely necessary.
     */
    private String modelVersion;

    /*
     * A list of PII entity categories that should be extracted and masked.
     */
    private List<String> piiCategories;

    /*
     * If specified, will set the PII domain to include only a subset of the entity categories. Possible values
     * include: 'phi', 'none'. Default is 'none'.
     */
    private String domain;

    /**
     * Creates an instance of PiiDetectionSkill class.
     *
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     */
    public PiiDetectionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    /**
     * Get the defaultLanguageCode property: A value indicating which language code to use. Default is `en`.
     *
     * @return the defaultLanguageCode value.
     */
    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    /**
     * Set the defaultLanguageCode property: A value indicating which language code to use. Default is `en`.
     *
     * @param defaultLanguageCode the defaultLanguageCode value to set.
     * @return the PiiDetectionSkill object itself.
     */
    public PiiDetectionSkill setDefaultLanguageCode(String defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    /**
     * Get the minimumPrecision property: A value between 0 and 1 that be used to only include entities whose confidence
     * score is greater than the value specified. If not set (default), or if explicitly set to null, all entities will
     * be included.
     *
     * @return the minimumPrecision value.
     */
    public Double getMinimumPrecision() {
        return this.minimumPrecision;
    }

    /**
     * Set the minimumPrecision property: A value between 0 and 1 that be used to only include entities whose confidence
     * score is greater than the value specified. If not set (default), or if explicitly set to null, all entities will
     * be included.
     *
     * @param minimumPrecision the minimumPrecision value to set.
     * @return the PiiDetectionSkill object itself.
     */
    public PiiDetectionSkill setMinimumPrecision(Double minimumPrecision) {
        this.minimumPrecision = minimumPrecision;
        return this;
    }

    /**
     * Get the maskingMode property: A parameter that provides various ways to mask the personal information detected in
     * the input text. Default is 'none'.
     *
     * @return the maskingMode value.
     */
    public PiiDetectionSkillMaskingMode getMaskingMode() {
        return this.maskingMode;
    }

    /**
     * Set the maskingMode property: A parameter that provides various ways to mask the personal information detected in
     * the input text. Default is 'none'.
     *
     * @param maskingMode the maskingMode value to set.
     * @return the PiiDetectionSkill object itself.
     */
    public PiiDetectionSkill setMaskingMode(PiiDetectionSkillMaskingMode maskingMode) {
        this.maskingMode = maskingMode;
        return this;
    }

    /**
     * Get the mask property: The character used to mask the text if the maskingMode parameter is set to replace.
     * Default is `*`.
     *
     * @return the mask value.
     */
    public String getMask() {
        return this.mask;
    }

    /**
     * Set the mask property: The character used to mask the text if the maskingMode parameter is set to replace.
     * Default is `*`.
     *
     * @param mask the mask value to set.
     * @return the PiiDetectionSkill object itself.
     */
    public PiiDetectionSkill setMask(String mask) {
        this.mask = mask;
        return this;
    }

    /**
     * Get the modelVersion property: The version of the model to use when calling the Text Analytics service. It will
     * default to the latest available when not specified. We recommend you do not specify this value unless absolutely
     * necessary.
     *
     * @return the modelVersion value.
     */
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * Set the modelVersion property: The version of the model to use when calling the Text Analytics service. It will
     * default to the latest available when not specified. We recommend you do not specify this value unless absolutely
     * necessary.
     *
     * @param modelVersion the modelVersion value to set.
     * @return the PiiDetectionSkill object itself.
     */
    public PiiDetectionSkill setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    /**
     * Get the piiCategories property: A list of PII entity categories that should be extracted and masked.
     *
     * @return the piiCategories value.
     */
    public List<String> getPiiCategories() {
        return this.piiCategories;
    }

    /**
     * Set the piiCategories property: A list of PII entity categories that should be extracted and masked.
     *
     * @param piiCategories the piiCategories value to set.
     * @return the PiiDetectionSkill object itself.
     */
    public PiiDetectionSkill setPiiCategories(List<String> piiCategories) {
        this.piiCategories = piiCategories;
        return this;
    }

    /**
     * Get the domain property: If specified, will set the PII domain to include only a subset of the entity categories.
     * Possible values include: 'phi', 'none'. Default is 'none'.
     *
     * @return the domain value.
     */
    public String getDomain() {
        return this.domain;
    }

    /**
     * Set the domain property: If specified, will set the PII domain to include only a subset of the entity categories.
     * Possible values include: 'phi', 'none'. Default is 'none'.
     *
     * @param domain the domain value to set.
     * @return the PiiDetectionSkill object itself.
     */
    public PiiDetectionSkill setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public PiiDetectionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public PiiDetectionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public PiiDetectionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Skills.Text.PIIDetectionSkill");
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("defaultLanguageCode", this.defaultLanguageCode);
        jsonWriter.writeNumberField("minimumPrecision", this.minimumPrecision);
        jsonWriter.writeStringField("maskingMode", Objects.toString(this.maskingMode, null));
        jsonWriter.writeStringField("maskingCharacter", this.mask);
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        jsonWriter.writeArrayField(
                "piiCategories", this.piiCategories, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("domain", this.domain);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PiiDetectionSkill from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PiiDetectionSkill if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties or the
     *     polymorphic discriminator.
     * @throws IOException If an error occurs while reading the PiiDetectionSkill.
     */
    public static PiiDetectionSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean inputsFound = false;
                    List<InputFieldMappingEntry> inputs = null;
                    boolean outputsFound = false;
                    List<OutputFieldMappingEntry> outputs = null;
                    String name = null;
                    String description = null;
                    String context = null;
                    String defaultLanguageCode = null;
                    Double minimumPrecision = null;
                    PiiDetectionSkillMaskingMode maskingMode = null;
                    String mask = null;
                    String modelVersion = null;
                    List<String> piiCategories = null;
                    String domain = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("@odata.type".equals(fieldName)) {
                            String odataType = reader.getString();
                            if (!"#Microsoft.Skills.Text.PIIDetectionSkill".equals(odataType)) {
                                throw new IllegalStateException(
                                        "'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.PIIDetectionSkill'. The found '@odata.type' was '"
                                                + odataType
                                                + "'.");
                            }
                        } else if ("inputs".equals(fieldName)) {
                            inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                            inputsFound = true;
                        } else if ("outputs".equals(fieldName)) {
                            outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                            outputsFound = true;
                        } else if ("name".equals(fieldName)) {
                            name = reader.getString();
                        } else if ("description".equals(fieldName)) {
                            description = reader.getString();
                        } else if ("context".equals(fieldName)) {
                            context = reader.getString();
                        } else if ("defaultLanguageCode".equals(fieldName)) {
                            defaultLanguageCode = reader.getString();
                        } else if ("minimumPrecision".equals(fieldName)) {
                            minimumPrecision = reader.getNullable(JsonReader::getDouble);
                        } else if ("maskingMode".equals(fieldName)) {
                            maskingMode = PiiDetectionSkillMaskingMode.fromString(reader.getString());
                        } else if ("maskingCharacter".equals(fieldName)) {
                            mask = reader.getString();
                        } else if ("modelVersion".equals(fieldName)) {
                            modelVersion = reader.getString();
                        } else if ("piiCategories".equals(fieldName)) {
                            piiCategories = reader.readArray(reader1 -> reader1.getString());
                        } else if ("domain".equals(fieldName)) {
                            domain = reader.getString();
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (inputsFound && outputsFound) {
                        PiiDetectionSkill deserializedPiiDetectionSkill = new PiiDetectionSkill(inputs, outputs);
                        deserializedPiiDetectionSkill.setName(name);
                        deserializedPiiDetectionSkill.setDescription(description);
                        deserializedPiiDetectionSkill.setContext(context);
                        deserializedPiiDetectionSkill.defaultLanguageCode = defaultLanguageCode;
                        deserializedPiiDetectionSkill.minimumPrecision = minimumPrecision;
                        deserializedPiiDetectionSkill.maskingMode = maskingMode;
                        deserializedPiiDetectionSkill.mask = mask;
                        deserializedPiiDetectionSkill.modelVersion = modelVersion;
                        deserializedPiiDetectionSkill.piiCategories = piiCategories;
                        deserializedPiiDetectionSkill.domain = domain;

                        return deserializedPiiDetectionSkill;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!inputsFound) {
                        missingProperties.add("inputs");
                    }
                    if (!outputsFound) {
                        missingProperties.add("outputs");
                    }

                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }
}
