// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

/** Defines the aggregation function used to combine the results of all the scoring functions in a scoring profile. */
public enum ScoringFunctionAggregation {
    /** Boost scores by the sum of all scoring function results. */
    SUM("sum"),

    /** Boost scores by the average of all scoring function results. */
    AVERAGE("average"),

    /** Boost scores by the minimum of all scoring function results. */
    MINIMUM("minimum"),

    /** Boost scores by the maximum of all scoring function results. */
    MAXIMUM("maximum"),

    /** Boost scores using the first applicable scoring function in the scoring profile. */
    FIRST_MATCHING("firstMatching");

    /** The actual serialized value for a ScoringFunctionAggregation instance. */
    private final String value;

    ScoringFunctionAggregation(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ScoringFunctionAggregation instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ScoringFunctionAggregation object, or null if unable to parse.
     */
    public static ScoringFunctionAggregation fromString(String value) {
        if (value == null) {
            return null;
        }
        ScoringFunctionAggregation[] items = ScoringFunctionAggregation.values();
        for (ScoringFunctionAggregation item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @Override
    public String toString() {
        return this.value;
    }
}
