// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/** Defines a combination of configurations to use with vector search. */
@Immutable
public final class VectorSearchProfile implements JsonSerializable<VectorSearchProfile> {
    /*
     * The name to associate with this particular vector search profile.
     */
    private final String name;

    /*
     * The name of the vector search algorithm configuration that specifies the algorithm and optional parameters.
     */
    private final String algorithmConfigurationName;

    /**
     * Creates an instance of VectorSearchProfile class.
     *
     * @param name the name value to set.
     * @param algorithmConfigurationName the algorithmConfigurationName value to set.
     */
    public VectorSearchProfile(String name, String algorithmConfigurationName) {
        this.name = name;
        this.algorithmConfigurationName = algorithmConfigurationName;
    }

    /**
     * Get the name property: The name to associate with this particular vector search profile.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the algorithmConfigurationName property: The name of the vector search algorithm configuration that specifies
     * the algorithm and optional parameters.
     *
     * @return the algorithmConfigurationName value.
     */
    public String getAlgorithmConfigurationName() {
        return this.algorithmConfigurationName;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("algorithm", this.algorithmConfigurationName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorSearchProfile from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorSearchProfile if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorSearchProfile.
     */
    public static VectorSearchProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean nameFound = false;
                    String name = null;
                    boolean algorithmConfigurationNameFound = false;
                    String algorithmConfigurationName = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("name".equals(fieldName)) {
                            name = reader.getString();
                            nameFound = true;
                        } else if ("algorithm".equals(fieldName)) {
                            algorithmConfigurationName = reader.getString();
                            algorithmConfigurationNameFound = true;
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (nameFound && algorithmConfigurationNameFound) {
                        VectorSearchProfile deserializedVectorSearchProfile =
                                new VectorSearchProfile(name, algorithmConfigurationName);

                        return deserializedVectorSearchProfile;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!nameFound) {
                        missingProperties.add("name");
                    }
                    if (!algorithmConfigurationNameFound) {
                        missingProperties.add("algorithm");
                    }

                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }
}
