// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/** A skill that can call a Web API endpoint, allowing you to extend a skillset by having it call your custom code. */
@Fluent
public final class WebApiSkill extends SearchIndexerSkill {
    /*
     * The url for the Web API.
     */
    private final String uri;

    /*
     * The headers required to make the http request.
     */
    private Map<String, String> httpHeaders;

    /*
     * The method for the http request.
     */
    private String httpMethod;

    /*
     * The desired timeout for the request. Default is 30 seconds.
     */
    private Duration timeout;

    /*
     * The desired batch size which indicates number of documents.
     */
    private Integer batchSize;

    /*
     * If set, the number of parallel calls that can be made to the Web API.
     */
    private Integer degreeOfParallelism;

    /**
     * Creates an instance of WebApiSkill class.
     *
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     * @param uri the uri value to set.
     */
    public WebApiSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, String uri) {
        super(inputs, outputs);
        this.uri = uri;
    }

    /**
     * Get the uri property: The url for the Web API.
     *
     * @return the uri value.
     */
    public String getUri() {
        return this.uri;
    }

    /**
     * Get the httpHeaders property: The headers required to make the http request.
     *
     * @return the httpHeaders value.
     */
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    /**
     * Set the httpHeaders property: The headers required to make the http request.
     *
     * @param httpHeaders the httpHeaders value to set.
     * @return the WebApiSkill object itself.
     */
    public WebApiSkill setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    /**
     * Get the httpMethod property: The method for the http request.
     *
     * @return the httpMethod value.
     */
    public String getHttpMethod() {
        return this.httpMethod;
    }

    /**
     * Set the httpMethod property: The method for the http request.
     *
     * @param httpMethod the httpMethod value to set.
     * @return the WebApiSkill object itself.
     */
    public WebApiSkill setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    /**
     * Get the timeout property: The desired timeout for the request. Default is 30 seconds.
     *
     * @return the timeout value.
     */
    public Duration getTimeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: The desired timeout for the request. Default is 30 seconds.
     *
     * @param timeout the timeout value to set.
     * @return the WebApiSkill object itself.
     */
    public WebApiSkill setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the batchSize property: The desired batch size which indicates number of documents.
     *
     * @return the batchSize value.
     */
    public Integer getBatchSize() {
        return this.batchSize;
    }

    /**
     * Set the batchSize property: The desired batch size which indicates number of documents.
     *
     * @param batchSize the batchSize value to set.
     * @return the WebApiSkill object itself.
     */
    public WebApiSkill setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    /**
     * Get the degreeOfParallelism property: If set, the number of parallel calls that can be made to the Web API.
     *
     * @return the degreeOfParallelism value.
     */
    public Integer getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    /**
     * Set the degreeOfParallelism property: If set, the number of parallel calls that can be made to the Web API.
     *
     * @param degreeOfParallelism the degreeOfParallelism value to set.
     * @return the WebApiSkill object itself.
     */
    public WebApiSkill setDegreeOfParallelism(Integer degreeOfParallelism) {
        this.degreeOfParallelism = degreeOfParallelism;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public WebApiSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public WebApiSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public WebApiSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Skills.Custom.WebApiSkill");
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeMapField("httpHeaders", this.httpHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("httpMethod", this.httpMethod);
        jsonWriter.writeStringField("timeout", Objects.toString(this.timeout, null));
        jsonWriter.writeNumberField("batchSize", this.batchSize);
        jsonWriter.writeNumberField("degreeOfParallelism", this.degreeOfParallelism);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebApiSkill from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebApiSkill if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties or the
     *     polymorphic discriminator.
     * @throws IOException If an error occurs while reading the WebApiSkill.
     */
    public static WebApiSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean inputsFound = false;
                    List<InputFieldMappingEntry> inputs = null;
                    boolean outputsFound = false;
                    List<OutputFieldMappingEntry> outputs = null;
                    String name = null;
                    String description = null;
                    String context = null;
                    boolean uriFound = false;
                    String uri = null;
                    Map<String, String> httpHeaders = null;
                    String httpMethod = null;
                    Duration timeout = null;
                    Integer batchSize = null;
                    Integer degreeOfParallelism = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("@odata.type".equals(fieldName)) {
                            String odataType = reader.getString();
                            if (!"#Microsoft.Skills.Custom.WebApiSkill".equals(odataType)) {
                                throw new IllegalStateException(
                                        "'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Custom.WebApiSkill'. The found '@odata.type' was '"
                                                + odataType
                                                + "'.");
                            }
                        } else if ("inputs".equals(fieldName)) {
                            inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                            inputsFound = true;
                        } else if ("outputs".equals(fieldName)) {
                            outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                            outputsFound = true;
                        } else if ("name".equals(fieldName)) {
                            name = reader.getString();
                        } else if ("description".equals(fieldName)) {
                            description = reader.getString();
                        } else if ("context".equals(fieldName)) {
                            context = reader.getString();
                        } else if ("uri".equals(fieldName)) {
                            uri = reader.getString();
                            uriFound = true;
                        } else if ("httpHeaders".equals(fieldName)) {
                            httpHeaders = reader.readMap(reader1 -> reader1.getString());
                        } else if ("httpMethod".equals(fieldName)) {
                            httpMethod = reader.getString();
                        } else if ("timeout".equals(fieldName)) {
                            timeout = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                        } else if ("batchSize".equals(fieldName)) {
                            batchSize = reader.getNullable(JsonReader::getInt);
                        } else if ("degreeOfParallelism".equals(fieldName)) {
                            degreeOfParallelism = reader.getNullable(JsonReader::getInt);
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (inputsFound && outputsFound && uriFound) {
                        WebApiSkill deserializedWebApiSkill = new WebApiSkill(inputs, outputs, uri);
                        deserializedWebApiSkill.setName(name);
                        deserializedWebApiSkill.setDescription(description);
                        deserializedWebApiSkill.setContext(context);
                        deserializedWebApiSkill.httpHeaders = httpHeaders;
                        deserializedWebApiSkill.httpMethod = httpMethod;
                        deserializedWebApiSkill.timeout = timeout;
                        deserializedWebApiSkill.batchSize = batchSize;
                        deserializedWebApiSkill.degreeOfParallelism = degreeOfParallelism;

                        return deserializedWebApiSkill;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!inputsFound) {
                        missingProperties.add("inputs");
                    }
                    if (!outputsFound) {
                        missingProperties.add("outputs");
                    }
                    if (!uriFound) {
                        missingProperties.add("uri");
                    }

                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }
}
