// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** Allows the user to choose whether a semantic call should fail completely, or to return partial results. */
public final class SemanticErrorMode extends ExpandableStringEnum<SemanticErrorMode> {
    /**
     * If the semantic processing fails, partial results still return. The definition of partial results depends on what
     * semantic step failed and what was the reason for failure.
     */
    public static final SemanticErrorMode PARTIAL = fromString("partial");

    /**
     * If there is an exception during the semantic processing step, the query will fail and return the appropriate HTTP
     * code depending on the error.
     */
    public static final SemanticErrorMode FAIL = fromString("fail");

    /**
     * Creates a new instance of SemanticErrorMode value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SemanticErrorMode() {}

    /**
     * Creates or finds a SemanticErrorMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SemanticErrorMode.
     */
    public static SemanticErrorMode fromString(String name) {
        return fromString(name, SemanticErrorMode.class);
    }

    /**
     * Gets known SemanticErrorMode values.
     *
     * @return known SemanticErrorMode values.
     */
    public static Collection<SemanticErrorMode> values() {
        return values(SemanticErrorMode.class);
    }
}
