/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.util.CoreUtils;
import com.azure.search.documents.indexes.models.DataChangeDetectionPolicy;
import com.azure.search.documents.indexes.models.DataDeletionDetectionPolicy;
import com.azure.search.documents.indexes.models.HighWaterMarkChangeDetectionPolicy;
import com.azure.search.documents.indexes.models.SearchIndexerDataContainer;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceType;

public final class SearchIndexerDataSources {
    public static SearchIndexerDataSourceConnection createFromAzureSql(String dataSourceName, String sqlConnectionString, String tableOrViewName, String description, DataChangeDetectionPolicy changeDetectionPolicy, DataDeletionDetectionPolicy deletionDetectionPolicy) {
        if (CoreUtils.isNullOrEmpty((CharSequence)dataSourceName)) {
            throw new IllegalArgumentException("'dataSourceName' cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)sqlConnectionString)) {
            throw new IllegalArgumentException("'sqlConnectionString' cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)tableOrViewName)) {
            throw new IllegalArgumentException("'tableOrViewName' cannot be null or empty.");
        }
        return SearchIndexerDataSources.createSearchIndexerDataSource(dataSourceName, SearchIndexerDataSourceType.AZURE_SQL, sqlConnectionString, tableOrViewName, null, description, changeDetectionPolicy, deletionDetectionPolicy);
    }

    public static SearchIndexerDataSourceConnection createFromAzureSql(String dataSourceName, String sqlConnectionString, String tableOrViewName) {
        return SearchIndexerDataSources.createFromAzureSql(dataSourceName, sqlConnectionString, tableOrViewName, null, null, null);
    }

    public static SearchIndexerDataSourceConnection createFromAzureBlobStorage(String dataSourceName, String storageConnectionString, String containerName, String pathPrefix, String description, DataDeletionDetectionPolicy deletionDetectionPolicy) {
        if (CoreUtils.isNullOrEmpty((CharSequence)dataSourceName)) {
            throw new IllegalArgumentException("'dataSourceName' cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)storageConnectionString)) {
            throw new IllegalArgumentException("'storageConnectionString' cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)containerName)) {
            throw new IllegalArgumentException("'containerName' cannot be null or empty.");
        }
        return SearchIndexerDataSources.createSearchIndexerDataSource(dataSourceName, SearchIndexerDataSourceType.AZURE_BLOB, storageConnectionString, containerName, pathPrefix, description, null, deletionDetectionPolicy);
    }

    public static SearchIndexerDataSourceConnection createFromAzureBlobStorage(String dataSourceName, String storageConnectionString, String containerName) {
        return SearchIndexerDataSources.createFromAzureBlobStorage(dataSourceName, storageConnectionString, containerName, null, null, null);
    }

    public static SearchIndexerDataSourceConnection createFromAzureTableStorage(String dataSourceName, String storageConnectionString, String tableName, String query, String description, DataDeletionDetectionPolicy deletionDetectionPolicy) {
        if (CoreUtils.isNullOrEmpty((CharSequence)dataSourceName)) {
            throw new IllegalArgumentException("'dataSourceName' cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("'tableName' cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)storageConnectionString)) {
            throw new IllegalArgumentException("'storageConnectionString' cannot be null or empty.");
        }
        return SearchIndexerDataSources.createSearchIndexerDataSource(dataSourceName, SearchIndexerDataSourceType.AZURE_TABLE, storageConnectionString, tableName, query, description, null, deletionDetectionPolicy);
    }

    public static SearchIndexerDataSourceConnection createFromAzureTableStorage(String dataSourceName, String storageConnectionString, String tableName) {
        return SearchIndexerDataSources.createFromAzureTableStorage(dataSourceName, storageConnectionString, tableName, null, null, null);
    }

    public static SearchIndexerDataSourceConnection createFromCosmos(String dataSourceName, String cosmosConnectionString, String collectionName, String query, Boolean useChangeDetection, String description, DataDeletionDetectionPolicy deletionDetectionPolicy) {
        if (CoreUtils.isNullOrEmpty((CharSequence)dataSourceName)) {
            throw new IllegalArgumentException("'dataSourceName' cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)collectionName)) {
            throw new IllegalArgumentException("'collectionName' cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)cosmosConnectionString)) {
            throw new IllegalArgumentException("'cosmosConnectionString' cannot be null or empty.");
        }
        HighWaterMarkChangeDetectionPolicy changeDetectionPolicy = useChangeDetection != false ? new HighWaterMarkChangeDetectionPolicy("_ts") : null;
        return SearchIndexerDataSources.createSearchIndexerDataSource(dataSourceName, SearchIndexerDataSourceType.COSMOS_DB, cosmosConnectionString, collectionName, query, description, changeDetectionPolicy, deletionDetectionPolicy);
    }

    public static SearchIndexerDataSourceConnection createFromCosmos(String dataSourceName, String cosmosConnectionString, String collectionName, Boolean useChangeDetection) {
        return SearchIndexerDataSources.createFromCosmos(dataSourceName, cosmosConnectionString, collectionName, null, useChangeDetection, null, null);
    }

    public static SearchIndexerDataSourceConnection createFromCosmos(String dataSourceName, String cosmosConnectionString, String collectionName) {
        return SearchIndexerDataSources.createFromCosmos(dataSourceName, cosmosConnectionString, collectionName, null, true, null, null);
    }

    private static SearchIndexerDataSourceConnection createSearchIndexerDataSource(String name, SearchIndexerDataSourceType type, String connectionString, String dataSourceName, String dataSourceQuery, String description, DataChangeDetectionPolicy dataChangeDetectionPolicy, DataDeletionDetectionPolicy dataDeletionDetectionPolicy) {
        return new SearchIndexerDataSourceConnection(name, type, connectionString, new SearchIndexerDataContainer(dataSourceName).setQuery(dataSourceQuery)).setDescription(description).setDataChangeDetectionPolicy(dataChangeDetectionPolicy).setDataDeletionDetectionPolicy(dataDeletionDetectionPolicy);
    }

    private SearchIndexerDataSources() {
    }
}

