/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class CoreToCodegenBridgeUtils {
    public static JsonWriter responseErrorToJson(JsonWriter jsonWriter, ResponseError responseError) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("code", responseError.getCode()).writeStringField("message", responseError.getMessage()).writeEndObject();
    }

    public static ResponseError responseErrorFromJson(JsonReader jsonReader) throws IOException {
        return (ResponseError)jsonReader.readObject(reader -> {
            JsonReader bufferedReader = reader.bufferObject();
            bufferedReader.nextToken();
            while (bufferedReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = bufferedReader.getFieldName();
                bufferedReader.nextToken();
                if ("error".equals(fieldName)) {
                    return CoreToCodegenBridgeUtils.readResponseError(bufferedReader);
                }
                bufferedReader.skipChildren();
            }
            return CoreToCodegenBridgeUtils.readResponseError(bufferedReader.reset());
        });
    }

    private static ResponseError readResponseError(JsonReader jsonReader) throws IOException {
        return (ResponseError)jsonReader.readObject(reader -> {
            String code = null;
            boolean codeFound = false;
            String message = null;
            boolean messageFound = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    codeFound = true;
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    messageFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (!codeFound && !messageFound) {
                throw new IllegalStateException("Missing required properties: code, message");
            }
            if (!codeFound) {
                throw new IllegalStateException("Missing required property: code");
            }
            if (!messageFound) {
                throw new IllegalStateException("Missing required property: message");
            }
            return new ResponseError(code, message);
        });
    }

    public static String durationToStringWithDays(Duration duration) {
        long milliseconds;
        long seconds;
        long minutes;
        long hours;
        if (duration == null) {
            return null;
        }
        if (duration.isZero()) {
            return "PT0S";
        }
        StringBuilder builder = new StringBuilder();
        if (duration.isNegative()) {
            builder.append("-P");
            duration = duration.negated();
        } else {
            builder.append('P');
        }
        long days = duration.toDays();
        if (days > 0L) {
            builder.append(days);
            builder.append('D');
            duration = duration.minusDays(days);
        }
        if ((hours = duration.toHours()) > 0L) {
            builder.append('T');
            builder.append(hours);
            builder.append('H');
            duration = duration.minusHours(hours);
        }
        if ((minutes = duration.toMinutes()) > 0L) {
            if (hours == 0L) {
                builder.append('T');
            }
            builder.append(minutes);
            builder.append('M');
            duration = duration.minusMinutes(minutes);
        }
        if ((seconds = duration.getSeconds()) > 0L) {
            if (hours == 0L && minutes == 0L) {
                builder.append('T');
            }
            builder.append(seconds);
            duration = duration.minusSeconds(seconds);
        }
        if ((milliseconds = duration.toMillis()) > 0L) {
            if (hours == 0L && minutes == 0L && seconds == 0L) {
                builder.append("T");
            }
            if (seconds == 0L) {
                builder.append("0");
            }
            builder.append('.');
            if (milliseconds <= 99L) {
                builder.append('0');
                if (milliseconds <= 9L) {
                    builder.append('0');
                }
            }
            while (milliseconds % 10L == 0L) {
                milliseconds /= 10L;
            }
            builder.append(milliseconds);
        }
        if (seconds > 0L || milliseconds > 0L) {
            builder.append('S');
        }
        return builder.toString();
    }
}

