/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class FieldMappingFunction
implements JsonSerializable<FieldMappingFunction> {
    private final String name;
    private Map<String, Object> parameters;

    public FieldMappingFunction(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public FieldMappingFunction setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static FieldMappingFunction fromJson(JsonReader jsonReader) throws IOException {
        return (FieldMappingFunction)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Map parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                FieldMappingFunction deserializedFieldMappingFunction = new FieldMappingFunction(name);
                deserializedFieldMappingFunction.parameters = parameters;
                return deserializedFieldMappingFunction;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

