/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizerV1;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizerV2;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import java.io.IOException;

public final class KeywordTokenizer
extends LexicalTokenizer {
    private final KeywordTokenizerV1 v1Tokenizer;
    private final KeywordTokenizerV2 v2Tokenizer;

    KeywordTokenizer(KeywordTokenizerV1 v1Tokenizer) {
        super(v1Tokenizer.getName());
        this.v1Tokenizer = v1Tokenizer;
        this.v2Tokenizer = null;
    }

    KeywordTokenizer(KeywordTokenizerV2 v2Tokenizer) {
        super(v2Tokenizer.getName());
        this.v1Tokenizer = null;
        this.v2Tokenizer = v2Tokenizer;
    }

    public KeywordTokenizer(String name) {
        super(name);
        this.v1Tokenizer = null;
        this.v2Tokenizer = new KeywordTokenizerV2(name);
    }

    public Integer getMaxTokenLength() {
        return this.v1Tokenizer != null ? this.v1Tokenizer.getBufferSize() : this.v2Tokenizer.getMaxTokenLength();
    }

    public KeywordTokenizer setMaxTokenLength(Integer maxTokenLength) {
        if (this.v1Tokenizer != null) {
            this.v1Tokenizer.setBufferSize(maxTokenLength);
        } else {
            this.v2Tokenizer.setMaxTokenLength(maxTokenLength);
        }
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.v1Tokenizer != null ? this.v1Tokenizer.toJson(jsonWriter) : this.v2Tokenizer.toJson(jsonWriter);
    }
}

