/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmConfiguration;
import com.azure.search.documents.indexes.models.VectorSearchCompression;
import com.azure.search.documents.indexes.models.VectorSearchProfile;
import com.azure.search.documents.indexes.models.VectorSearchVectorizer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class VectorSearch
implements JsonSerializable<VectorSearch> {
    private List<VectorSearchProfile> profiles;
    private List<VectorSearchAlgorithmConfiguration> algorithms;
    private List<VectorSearchVectorizer> vectorizers;
    private List<VectorSearchCompression> compressions;

    public List<VectorSearchProfile> getProfiles() {
        return this.profiles;
    }

    public VectorSearch setProfiles(List<VectorSearchProfile> profiles) {
        this.profiles = profiles;
        return this;
    }

    public List<VectorSearchAlgorithmConfiguration> getAlgorithms() {
        return this.algorithms;
    }

    public VectorSearch setAlgorithms(List<VectorSearchAlgorithmConfiguration> algorithms) {
        this.algorithms = algorithms;
        return this;
    }

    public List<VectorSearchVectorizer> getVectorizers() {
        return this.vectorizers;
    }

    public VectorSearch setVectorizers(List<VectorSearchVectorizer> vectorizers) {
        this.vectorizers = vectorizers;
        return this;
    }

    public List<VectorSearchCompression> getCompressions() {
        return this.compressions;
    }

    public VectorSearch setCompressions(List<VectorSearchCompression> compressions) {
        this.compressions = compressions;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("profiles", this.profiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("algorithms", this.algorithms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("vectorizers", this.vectorizers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("compressions", this.compressions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VectorSearch fromJson(JsonReader jsonReader) throws IOException {
        return (VectorSearch)jsonReader.readObject(reader -> {
            VectorSearch deserializedVectorSearch = new VectorSearch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("profiles".equals(fieldName)) {
                    List profiles;
                    deserializedVectorSearch.profiles = profiles = reader.readArray(reader1 -> VectorSearchProfile.fromJson(reader1));
                    continue;
                }
                if ("algorithms".equals(fieldName)) {
                    List algorithms;
                    deserializedVectorSearch.algorithms = algorithms = reader.readArray(reader1 -> VectorSearchAlgorithmConfiguration.fromJson(reader1));
                    continue;
                }
                if ("vectorizers".equals(fieldName)) {
                    List vectorizers;
                    deserializedVectorSearch.vectorizers = vectorizers = reader.readArray(reader1 -> VectorSearchVectorizer.fromJson(reader1));
                    continue;
                }
                if ("compressions".equals(fieldName)) {
                    List compressions;
                    deserializedVectorSearch.compressions = compressions = reader.readArray(reader1 -> VectorSearchCompression.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorSearch;
        });
    }

    public VectorSearch setProfiles(VectorSearchProfile ... profiles) {
        this.profiles = profiles == null ? null : Arrays.asList(profiles);
        return this;
    }

    public VectorSearch setAlgorithms(VectorSearchAlgorithmConfiguration ... algorithms) {
        this.algorithms = algorithms == null ? null : Arrays.asList(algorithms);
        return this;
    }

    public VectorSearch setCompressions(VectorSearchCompression ... compressions) {
        this.compressions = compressions == null ? null : Arrays.asList(compressions);
        return this;
    }

    public VectorSearch setVectorizers(VectorSearchVectorizer ... vectorizers) {
        this.vectorizers = vectorizers == null ? null : Arrays.asList(vectorizers);
        return this;
    }
}

