/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming;

import com.baidu.brpc.client.CommunicationClient;
import com.baidu.brpc.naming.NamingServiceProcessor;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.RpcRequest;
import com.baidu.brpc.protocol.RpcResponse;
import com.baidu.brpc.thread.ClientHealthCheckTimerInstance;
import io.netty.channel.Channel;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthyCheckTimer
implements TimerTask {
    private static final Logger log = LoggerFactory.getLogger(HealthyCheckTimer.class);
    private NamingServiceProcessor instanceProcessor;
    private Timer timer = ClientHealthCheckTimerInstance.getOrCreateInstance();
    private int healthyCheckIntervalMillis;
    private volatile boolean stop = false;

    public HealthyCheckTimer(NamingServiceProcessor instanceProcessor, int healthyCheckIntervalMillis) {
        this.instanceProcessor = instanceProcessor;
        this.healthyCheckIntervalMillis = healthyCheckIntervalMillis;
    }

    public void start() {
        this.timer.newTimeout((TimerTask)this, (long)this.healthyCheckIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout timeout) {
        if (!this.stop) {
            ArrayList<CommunicationClient> newHealthyInstances = new ArrayList<CommunicationClient>();
            for (CommunicationClient instance : this.instanceProcessor.getUnhealthyInstances()) {
                boolean isHealthy = this.isInstanceHealthy(instance);
                if (!isHealthy) continue;
                newHealthyInstances.add(instance);
            }
            ArrayList<CommunicationClient> newUnhealthyInstances = new ArrayList<CommunicationClient>();
            for (CommunicationClient instance : this.instanceProcessor.getHealthyInstances()) {
                boolean isHealthy = this.isInstanceHealthy(instance);
                if (isHealthy) continue;
                newUnhealthyInstances.add(instance);
            }
            this.instanceProcessor.getLock().lock();
            try {
                if (newUnhealthyInstances.size() > 0) {
                    this.instanceProcessor.getHealthyInstances().removeAll(newUnhealthyInstances);
                    this.instanceProcessor.getUnhealthyInstances().addAll(newUnhealthyInstances);
                }
                if (newHealthyInstances.size() > 0) {
                    this.instanceProcessor.getHealthyInstances().addAll(newHealthyInstances);
                    this.instanceProcessor.getUnhealthyInstances().removeAll(newHealthyInstances);
                }
            }
            finally {
                this.instanceProcessor.getLock().unlock();
            }
            this.timer.newTimeout((TimerTask)this, (long)this.healthyCheckIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isInstanceHealthy(CommunicationClient instance) {
        boolean healthy = false;
        try {
            if (instance.getCommunicationOptions().getProtocol().supportHeartbeat()) {
                RpcRequest request = new RpcRequest();
                request.reset();
                request.setHeartbeat(true);
                request.setReadTimeoutMillis(Integer.valueOf(instance.getCommunicationOptions().getReadTimeoutMillis()));
                request.setWriteTimeoutMillis(Integer.valueOf(instance.getCommunicationOptions().getWriteTimeoutMillis()));
                RpcResponse response = new RpcResponse();
                response.reset();
                if (!instance.getStop().get()) {
                    instance.execute((Request)request, (Response)response);
                    if (response.getException() != null) {
                        throw response.getException();
                    }
                }
            } else {
                Channel channel = instance.selectChannel();
                instance.getBrpcChannel().returnChannel(channel);
            }
            healthy = true;
        }
        catch (Throwable ex) {
            healthy = false;
        }
        log.debug("instance[{}:{}] healthy is {}", new Object[]{instance.getServiceInstance().getIp(), instance.getServiceInstance().getPort(), healthy});
        return healthy;
    }
}

