/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.moladb.model.AttributeDefinition;
import com.baidubce.services.moladb.model.KeySchemaElement;
import com.baidubce.services.moladb.model.ProvisionedThroughput;
import com.baidubce.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CreateTableRequest
extends AbstractBceRequest {
    private String tableName;
    private List<KeySchemaElement> keySchema;
    private ProvisionedThroughput provisionedThroughput;
    private List<AttributeDefinition> attributeDefinitions;

    public CreateTableRequest() {
    }

    public CreateTableRequest(String name) {
        this.tableName = name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public CreateTableRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public void setAttributeDefinitions(List<AttributeDefinition> attributeDefinitions) {
        this.attributeDefinitions = attributeDefinitions;
    }

    public CreateTableRequest withAttributeDefinitions(List<AttributeDefinition> attributeDefinitions) {
        this.setAttributeDefinitions(attributeDefinitions);
        return this;
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setKeySchema(List<KeySchemaElement> keySchema) {
        this.keySchema = keySchema;
    }

    public CreateTableRequest withKeySchema(List<KeySchemaElement> keySchema) {
        this.setKeySchema(keySchema);
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setProvisionedThroughput(ProvisionedThroughput provision) {
        this.provisionedThroughput = provision;
    }

    public CreateTableRequest withProvisionedThroughput(ProvisionedThroughput provision) {
        this.setProvisionedThroughput(provision);
        return this;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public String toString() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("attributeDefinitions", this.attributeDefinitionsToJson(this.attributeDefinitions));
        result.put("keySchema", this.keySchemaToJson(this.keySchema));
        result.put("provisionedThroughput", this.provisionedThroughput.toJsonObj());
        result.put("tableName", this.tableName);
        return JsonUtils.toJsonString(result);
    }

    @Override
    public CreateTableRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    private List<Object> keySchemaToJson(List<KeySchemaElement> schema) {
        ArrayList<Object> obj = new ArrayList<Object>();
        for (KeySchemaElement element : schema) {
            obj.add(element.toJsonObj());
        }
        return obj;
    }

    private List<Object> attributeDefinitionsToJson(List<AttributeDefinition> attributes) {
        ArrayList<Object> obj = new ArrayList<Object>();
        for (AttributeDefinition element : attributes) {
            obj.add(element.toJsonObj());
        }
        return obj;
    }
}

