/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.services.moladb.model.ProvisionedThroughputDescription;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.SimpleDateFormat;

public class ProvisionedThroughputUnmarshaller
implements Unmarshaller<ProvisionedThroughputDescription, JsonNode> {
    @Override
    public ProvisionedThroughputDescription unmarshall(JsonNode jsonObj) throws Exception {
        if (!jsonObj.isObject()) {
            throw new BceClientException("input json object is not an object");
        }
        ProvisionedThroughputDescription provision = new ProvisionedThroughputDescription();
        try {
            JsonNode decTimeObj = jsonObj.get("lastDecreaseDateTime");
            JsonNode incTimeObj = jsonObj.get("lastIncreaseDateTime");
            JsonNode decTodayObj = jsonObj.get("numberOfDecreasesToday");
            JsonNode readCapObj = jsonObj.get("readCapacityUnits");
            JsonNode writeCapObj = jsonObj.get("writeCapacityUnits");
            SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            if (decTimeObj != null) {
                provision.setLastDescreaseDateTime(dateParser.parse(decTimeObj.asText()));
            }
            if (incTimeObj != null) {
                provision.setLastIncreaseDateTime(dateParser.parse(incTimeObj.asText()));
            }
            if (decTodayObj != null) {
                provision.setNumberOfDecreasesToday(decTodayObj.asInt());
            }
            provision.setReadCapacityUnits(readCapObj.asLong());
            provision.setWriteCapacityUnits(writeCapObj.asLong());
        }
        catch (Exception e) {
            throw new BceClientException("Invalid responseContent:" + jsonObj.toString() + " meet exception:" + e.toString());
        }
        return provision;
    }
}

