/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ocr.model;

import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.ocr.model.FormAbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class IdcardRecognitionRequest
extends FormAbstractBceRequest {
    private String image;
    @JsonProperty(value="id_card_side")
    private String side;
    @JsonProperty(value="detect_direction")
    private Boolean direction = false;

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public IdcardRecognitionRequest withImage(String image) {
        this.image = image;
        return this;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public IdcardRecognitionRequest withSide(String side) {
        this.side = side;
        return this;
    }

    public Boolean getDirection() {
        return this.direction;
    }

    public void setDirection(Boolean direction) {
        this.direction = direction;
    }

    public IdcardRecognitionRequest withDirection(Boolean direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public String toFormString() {
        try {
            return "image=" + URLEncoder.encode(this.image, "UTF-8") + "&" + "id_card_side=" + this.side + "&" + "detect_direction=" + this.direction;
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
    }

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public String toString() {
        return "IdcardRecognitionRequest{image='" + this.image + '\'' + ", side='" + this.side + '\'' + ", direction=" + this.direction + '}';
    }
}

