/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.sql.StringEscape;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringUtils {
    public static final String UTF8 = "UTF-8";
    public static final String EMPTY = "";
    public static final String IS = "is";
    public static final char UNDERLINE = '_';
    public static final String PLACE_HOLDER = "{%s}";

    private StringUtils() {
    }

    public static String blob2String(Blob blob) {
        if (null != blob) {
            try {
                byte[] returnValue = blob.getBytes(1L, (int)blob.length());
                return new String(returnValue, UTF8);
            }
            catch (Exception e) {
                throw new MybatisPlusException("Blob Convert To String Error!");
            }
        }
        return null;
    }

    public static boolean isEmpty(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static String camelToUnderline(String param) {
        if (StringUtils.isEmpty(param)) {
            return EMPTY;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String resolveFieldName(String getMethodName) {
        if (getMethodName.startsWith("get")) {
            getMethodName = getMethodName.substring(3, getMethodName.length());
        } else if (getMethodName.startsWith(IS)) {
            getMethodName = getMethodName.substring(2, getMethodName.length());
        }
        return StringUtils.firstToLowerCase(getMethodName);
    }

    public static String underlineToCamel(String param) {
        if (StringUtils.isEmpty(param)) {
            return EMPTY;
        }
        String temp = param.toLowerCase();
        int len = temp.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = temp.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(temp.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String firstToLowerCase(String param) {
        if (StringUtils.isEmpty(param)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(param.length());
        sb.append(param.substring(0, 1).toLowerCase());
        sb.append(param.substring(1));
        return sb.toString();
    }

    public static boolean isUpperCase(String str) {
        return StringUtils.matches("^[A-Z]+$", str);
    }

    public static boolean matches(String regex, String input) {
        if (null == regex || null == input) {
            return false;
        }
        return Pattern.matches(regex, input);
    }

    public static String sqlArgsFill(String content, Object ... args) {
        int length;
        if (StringUtils.isEmpty(content)) {
            return null;
        }
        if (args != null && (length = args.length) >= 1) {
            for (int i = 0; i < length; ++i) {
                content = content.replace(String.format(PLACE_HOLDER, i), StringUtils.sqlParam(args[i]));
            }
        }
        return content;
    }

    public static String sqlParam(Object obj) {
        String repStr = obj instanceof Collection ? StringUtils.quotaMarkList((Collection)obj) : StringUtils.quotaMark(obj);
        return repStr;
    }

    public static String quotaMark(Object obj) {
        String srcStr = String.valueOf(obj);
        if (obj instanceof CharSequence) {
            return StringEscape.escapeString(srcStr);
        }
        return srcStr;
    }

    public static String quotaMarkList(Collection<?> coll) {
        return coll.stream().map(StringUtils::quotaMark).collect(Collectors.joining(",", "(", ")"));
    }

    public static String concatCapitalize(String concatStr, String str) {
        int strLen;
        if (StringUtils.isEmpty(concatStr)) {
            concatStr = EMPTY;
        }
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(strLen);
        sb.append(concatStr);
        sb.append(Character.toTitleCase(firstChar));
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static String capitalize(String str) {
        return StringUtils.concatCapitalize(null, str);
    }

    public static boolean checkValNotNull(Object object) {
        if (object instanceof CharSequence) {
            return StringUtils.isNotEmpty((CharSequence)object);
        }
        return object != null;
    }

    public static boolean checkValNull(Object object) {
        return !StringUtils.checkValNotNull(object);
    }

    public static boolean containsUpperCase(String word) {
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCapitalMode(String word) {
        return null != word && word.matches("^[0-9A-Z/_]+$");
    }

    public static boolean isMixedMode(String word) {
        return StringUtils.matches(".*[A-Z]+.*", word) && StringUtils.matches(".*[/_]+.*", word);
    }

    public static boolean endsWith(String str, String suffix) {
        return StringUtils.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return StringUtils.endsWith(str, suffix, true);
    }

    private static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static String[] split(String str, String separatorChars) {
        List<String> strings = StringUtils.splitWorker(str, separatorChars, -1, false);
        return strings.toArray(new String[strings.size()]);
    }

    public static List<String> splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list;
    }

    public static Boolean isCharSequence(Class<?> cls) {
        return cls != null && CharSequence.class.isAssignableFrom(cls);
    }

    public static String removeIsPrefixIfBoolean(String propertyName, Class<?> propertyType) {
        if (StringUtils.isBoolean(propertyType).booleanValue() && propertyName.startsWith(IS)) {
            String property = propertyName.replaceFirst(IS, EMPTY);
            if (StringUtils.isEmpty(property)) {
                return propertyName;
            }
            String firstCharToLowerStr = StringUtils.firstCharToLower(property);
            return property.equals(firstCharToLowerStr) ? propertyName : firstCharToLowerStr;
        }
        return propertyName;
    }

    public static Boolean isCharSequence(String propertyType) {
        try {
            return StringUtils.isCharSequence(Class.forName(propertyType));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Boolean isBoolean(Class<?> propertyCls) {
        return propertyCls != null && (Boolean.TYPE.isAssignableFrom(propertyCls) || Boolean.class.isAssignableFrom(propertyCls));
    }

    public static String firstCharToLower(String rawString) {
        return StringUtils.prefixToLower(rawString, 1);
    }

    public static String prefixToLower(String rawString, int index) {
        String beforeChar = rawString.substring(0, index).toLowerCase();
        String afterChar = rawString.substring(index, rawString.length());
        return beforeChar + afterChar;
    }

    public static String removePrefixAfterPrefixToLower(String rawString, int index) {
        return StringUtils.prefixToLower(rawString.substring(index, rawString.length()), 1);
    }

    public static String camelToHyphen(String input) {
        return StringUtils.wordsToHyphenCase(StringUtils.wordsAndHyphenAndCamelToConstantCase(input));
    }

    private static String wordsAndHyphenAndCamelToConstantCase(String input) {
        boolean betweenUpperCases = false;
        boolean containsLowerCase = StringUtils.containsLowerCase(input);
        StringBuilder buf = new StringBuilder();
        char previousChar = ' ';
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean isNotUnderscore;
            char c = chars[i];
            boolean isUpperCaseAndPreviousIsUpperCase = Character.isUpperCase(previousChar) && Character.isUpperCase(c);
            boolean isUpperCaseAndPreviousIsLowerCase = Character.isLowerCase(previousChar) && Character.isUpperCase(c);
            boolean previousIsWhitespace = Character.isWhitespace(previousChar);
            boolean lastOneIsNotUnderscore = buf.length() > 0 && buf.charAt(buf.length() - 1) != '_';
            boolean bl = isNotUnderscore = c != '_';
            if (lastOneIsNotUnderscore && (isUpperCaseAndPreviousIsLowerCase || previousIsWhitespace || betweenUpperCases && containsLowerCase && isUpperCaseAndPreviousIsUpperCase)) {
                buf.append("_");
            } else if (Character.isDigit(previousChar) && Character.isLetter(c)) {
                buf.append('_');
            }
            if (StringUtils.shouldReplace(c) && lastOneIsNotUnderscore) {
                buf.append('_');
            } else if (!Character.isWhitespace(c) && (isNotUnderscore || lastOneIsNotUnderscore)) {
                buf.append(Character.toUpperCase(c));
            }
            previousChar = c;
        }
        if (Character.isWhitespace(previousChar)) {
            buf.append("_");
        }
        return buf.toString();
    }

    public static boolean containsLowerCase(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldReplace(char c) {
        return c == '.' || c == '_' || c == '-';
    }

    private static String wordsToHyphenCase(String s) {
        StringBuilder buf = new StringBuilder();
        char lastChar = 'a';
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(lastChar) && !Character.isWhitespace(c) && '-' != c && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append("-");
            }
            if ('_' == c) {
                buf.append('-');
            } else if ('.' == c) {
                buf.append('-');
            } else if (!Character.isWhitespace(c)) {
                buf.append(Character.toLowerCase(c));
            }
            lastChar = c;
        }
        if (Character.isWhitespace(lastChar)) {
            buf.append("-");
        }
        return buf.toString();
    }
}

