/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class GlobalConfigUtils {
    private static final Log logger = LogFactory.getLog(GlobalConfigUtils.class);
    public static final GlobalConfig DEFAULT = GlobalConfigUtils.defaults();
    private static final Map<String, GlobalConfig> GLOBAL_CONFIG = new ConcurrentHashMap<String, GlobalConfig>();

    public static SqlSessionFactory currentSessionFactory(Class<?> clazz) {
        String configMark = TableInfoHelper.getTableInfo(clazz).getConfigMark();
        GlobalConfig mybatisGlobalConfig = GlobalConfigUtils.getGlobalConfig(configMark);
        return mybatisGlobalConfig.getSqlSessionFactory();
    }

    public static GlobalConfig defaults() {
        GlobalConfig config = new GlobalConfig();
        config.setDbConfig(new GlobalConfig.DbConfig());
        return config;
    }

    public static void setGlobalConfig(Configuration configuration, GlobalConfig mybatisGlobalConfig) {
        if (configuration == null || mybatisGlobalConfig == null) {
            throw new MybatisPlusException("Error: Could not setGlobalConfig");
        }
        GLOBAL_CONFIG.put(configuration.toString(), mybatisGlobalConfig);
    }

    public static GlobalConfig getGlobalConfig(Configuration configuration) {
        if (configuration == null) {
            throw new MybatisPlusException("Error: You need Initialize MybatisConfiguration !");
        }
        return GlobalConfigUtils.getGlobalConfig(configuration.toString());
    }

    public static GlobalConfig getGlobalConfig(String configMark) {
        GlobalConfig cache = GLOBAL_CONFIG.get(configMark);
        if (cache == null) {
            logger.debug("DeBug: MyBatis Plus Global configuration Initializing !");
            GLOBAL_CONFIG.put(configMark, DEFAULT);
            return DEFAULT;
        }
        return cache;
    }

    public static DbType getDbType(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getDbConfig().getDbType();
    }

    public static IKeyGenerator getKeyGenerator(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getDbConfig().getKeyGenerator();
    }

    public static IdType getIdType(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getDbConfig().getIdType();
    }

    public static boolean isDbColumnUnderline(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getDbConfig().isColumnUnderline();
    }

    public static ISqlInjector getSqlInjector(Configuration configuration) {
        GlobalConfig globalConfiguration = GlobalConfigUtils.getGlobalConfig(configuration);
        ISqlInjector sqlInjector = globalConfiguration.getSqlInjector();
        if (sqlInjector == null) {
            sqlInjector = new DefaultSqlInjector();
            globalConfiguration.setSqlInjector(sqlInjector);
        }
        return sqlInjector;
    }

    public static MetaObjectHandler getMetaObjectHandler(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getMetaObjectHandler();
    }

    public static boolean isRefresh(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).isRefresh();
    }

    public static Set<String> getMapperRegistryCache(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getMapperRegistryCache();
    }

    public static SqlSession getSqlSession(Configuration configuration) {
        return GlobalConfigUtils.getGlobalConfig(configuration).getSqlSession();
    }
}

