/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.ddl;

import java.sql.SQLException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

@FunctionalInterface
public interface DdlScriptErrorHandler {
    public void handle(String var1, Exception var2) throws SQLException;

    public static class ThrowsErrorHandler
    implements DdlScriptErrorHandler {
        public static final ThrowsErrorHandler INSTANCE = new ThrowsErrorHandler();

        @Override
        public void handle(String sqlFile, Exception throwable) throws SQLException {
            throw new SQLException("Execute " + sqlFile + " fail. ", throwable);
        }
    }

    public static class PrintlnLogErrorHandler
    implements DdlScriptErrorHandler {
        public static final PrintlnLogErrorHandler INSTANCE = new PrintlnLogErrorHandler();
        public static final Log log = LogFactory.getLog(PrintlnLogErrorHandler.class);

        @Override
        public void handle(String sqlFile, Exception throwable) {
            log.error("run script sql:" + sqlFile + ", error: ", (Throwable)throwable);
        }
    }
}

