/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.handlers;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import java.lang.reflect.Field;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.type.TypeFactory;

public class Jackson3TypeHandler
extends AbstractJsonTypeHandler<Object> {
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public Jackson3TypeHandler(Class<?> type) {
        super(type);
    }

    public Jackson3TypeHandler(Class<?> type, Field field) {
        super(type, field);
    }

    public Object parse(String json) {
        ObjectMapper objectMapper = Jackson3TypeHandler.getObjectMapper();
        TypeFactory typeFactory = objectMapper.getTypeFactory();
        JavaType javaType = typeFactory.constructType(this.getFieldType());
        return objectMapper.readValue(json, javaType);
    }

    public String toJson(Object obj) {
        return Jackson3TypeHandler.getObjectMapper().writeValueAsString(obj);
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER == null ? Instance.OBJECT_MAPPER : new ObjectMapper();
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper should not be null", (Object[])new Object[0]);
        OBJECT_MAPPER = objectMapper;
    }

    private static class Instance {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        private Instance() {
        }
    }
}

