/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.toolkit;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.UpdateChainWrapper;
import com.baomidou.mybatisplus.extension.kotlin.KtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.kotlin.KtUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.toolkit.ChainWrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class Db {
    private static final Log log = LogFactory.getLog(Db.class);

    private Db() {
    }

    public static <T> boolean save(T entity) {
        if (Objects.isNull(entity)) {
            return false;
        }
        Integer result = (Integer)SqlHelper.execute(Db.getEntityClass(entity), (SFunction & Serializable)baseMapper -> baseMapper.insert(entity));
        return SqlHelper.retBool(result);
    }

    public static <T> boolean saveBatch(Collection<T> entityList) {
        return Db.saveBatch(entityList, 1000);
    }

    public static <T> boolean saveBatch(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            return false;
        }
        Class<Collection<T>> entityClass = Db.getEntityClass(entityList);
        List batchResults = (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.insert(entityList, batchSize));
        return batchResults.stream().flatMapToInt(r -> IntStream.of(r.getUpdateCounts())).allMatch(i -> i > 0);
    }

    public static <T> boolean saveOrUpdateBatch(Collection<T> entityList) {
        return Db.saveOrUpdateBatch(entityList, 1000);
    }

    public static <T> boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            return false;
        }
        Class<Collection<T>> entityClass = Db.getEntityClass(entityList);
        List batchResults = (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.insertOrUpdate(entityList, batchSize));
        return batchResults.stream().flatMapToInt(r -> IntStream.of(r.getUpdateCounts())).allMatch(i -> i > 0);
    }

    public static <T> boolean removeById(Serializable id, Class<T> entityClass) {
        return (Boolean)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> SqlHelper.retBool(baseMapper.deleteById(id)));
    }

    public static <T> boolean removeById(T entity) {
        if (Objects.isNull(entity)) {
            return false;
        }
        return (Boolean)SqlHelper.execute(Db.getEntityClass(entity), (SFunction & Serializable)baseMapper -> SqlHelper.retBool(baseMapper.deleteById(entity)));
    }

    public static <T> boolean remove(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (Boolean)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> SqlHelper.retBool(baseMapper.delete((Wrapper)queryWrapper)));
    }

    public static <T> boolean updateById(T entity) {
        if (Objects.isNull(entity)) {
            return false;
        }
        return (Boolean)SqlHelper.execute(Db.getEntityClass(entity), (SFunction & Serializable)baseMapper -> SqlHelper.retBool(baseMapper.updateById(entity)));
    }

    public static <T> boolean update(AbstractWrapper<T, ?, ?> updateWrapper) {
        return Db.update(null, updateWrapper);
    }

    public static <T> boolean update(T entity, AbstractWrapper<T, ?, ?> updateWrapper) {
        return (Boolean)SqlHelper.execute(Db.getEntityClass(updateWrapper), (SFunction & Serializable)baseMapper -> SqlHelper.retBool(baseMapper.update(entity, (Wrapper)updateWrapper)));
    }

    public static <T> boolean updateBatchById(Collection<T> entityList) {
        return Db.updateBatchById(entityList, 1000);
    }

    public static <T> boolean updateBatchById(Collection<T> entityList, int batchSize) {
        Class<Collection<T>> entityClass = Db.getEntityClass(entityList);
        List batchResults = (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.updateById(entityList, batchSize));
        return batchResults.stream().flatMapToInt(r -> IntStream.of(r.getUpdateCounts())).allMatch(i -> i > 0);
    }

    public static <T> boolean removeByIds(Collection<? extends Serializable> list, Class<T> entityClass) {
        return (Boolean)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> SqlHelper.retBool(baseMapper.deleteByIds(list)));
    }

    public static <T> boolean removeByMap(Map<String, Object> columnMap, Class<T> entityClass) {
        return (Boolean)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> SqlHelper.retBool(baseMapper.deleteByMap(columnMap)));
    }

    public static <T> boolean saveOrUpdate(T entity) {
        if (Objects.isNull(entity)) {
            return false;
        }
        return (Boolean)SqlHelper.execute(Db.getEntityClass(entity), (SFunction & Serializable)baseMapper -> baseMapper.insertOrUpdate(entity));
    }

    public static <T> T getById(Serializable id, Class<T> entityClass) {
        return (T)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectById(id));
    }

    public static <T> T getOne(AbstractWrapper<T, ?, ?> queryWrapper) {
        return Db.getOne(queryWrapper, true);
    }

    public static <T> T getOne(T entity) {
        return Db.getOne(Wrappers.lambdaQuery(entity), true);
    }

    public static <T> T getOne(T entity, boolean throwEx) {
        return Db.getOne(Wrappers.lambdaQuery(entity), throwEx);
    }

    public static <T> T getOne(AbstractWrapper<T, ?, ?> queryWrapper, boolean throwEx) {
        Class<AbstractWrapper<T, ?, ?>> entityClass = Db.getEntityClass(queryWrapper);
        if (throwEx) {
            return (T)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectOne((Wrapper)queryWrapper));
        }
        return (T)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> SqlHelper.getObject(log, baseMapper.selectList((Wrapper)queryWrapper)));
    }

    public static <T> List<T> listByMap(Map<String, Object> columnMap, Class<T> entityClass) {
        return (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectByMap(columnMap));
    }

    public static <T> List<T> listByIds(Collection<? extends Serializable> idList, Class<T> entityClass) {
        return (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectBatchIds(idList));
    }

    public static <T> Map<String, Object> getMap(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (Map)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (Map)SqlHelper.getObject(log, baseMapper.selectMaps((Wrapper)queryWrapper)));
    }

    public static <T> Map<String, Object> getMap(T entity) {
        return Db.getMap(Wrappers.lambdaQuery(entity));
    }

    public static <T> long count(Class<T> entityClass) {
        return (Long)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectCount(null));
    }

    public static <T> long count(T entity) {
        return Db.count(Wrappers.lambdaQuery(entity));
    }

    public static <T> long count(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (Long)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> baseMapper.selectCount((Wrapper)queryWrapper));
    }

    public static <T> List<T> list(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (List)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> baseMapper.selectList((Wrapper)queryWrapper));
    }

    public static <T> List<T> list(IPage<T> page, AbstractWrapper<T, ?, ?> queryWrapper) {
        return (List)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> baseMapper.selectList(page, (Wrapper)queryWrapper));
    }

    public static <T> List<T> list(Class<T> entityClass) {
        return (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectList(null));
    }

    public static <T> List<T> list(IPage<T> page, Class<T> entityClass) {
        return (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectList(page, null));
    }

    public static <T> List<T> list(T entity) {
        return Db.list(Wrappers.lambdaQuery(entity));
    }

    public static <T> List<T> list(IPage<T> page, T entity) {
        return Db.list(page, Wrappers.lambdaQuery(entity));
    }

    public static <T> List<Map<String, Object>> listMaps(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (List)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> baseMapper.selectMaps((Wrapper)queryWrapper));
    }

    public static <T> List<Map<String, Object>> listMaps(IPage<? extends Map<String, Object>> page, AbstractWrapper<T, ?, ?> queryWrapper) {
        return (List)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> baseMapper.selectMaps(page, (Wrapper)queryWrapper));
    }

    public static <T> List<Map<String, Object>> listMaps(Class<T> entityClass) {
        return (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectMaps(null));
    }

    public static <T> List<Map<String, Object>> listMaps(IPage<? extends Map<String, Object>> page, Class<T> entityClass) {
        return (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectMaps(page, null));
    }

    public static <T> List<Map<String, Object>> listMaps(T entity) {
        return Db.listMaps(Wrappers.lambdaQuery(entity));
    }

    public static <T> List<Map<String, Object>> listMaps(IPage<? extends Map<String, Object>> page, T entity) {
        return Db.listMaps(page, Wrappers.lambdaQuery(entity));
    }

    public static <T> List<T> listObjs(Class<T> entityClass) {
        return Db.listObjs(entityClass, (SFunction & Serializable)i -> i);
    }

    public static <E, T> List<E> listObjs(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (List)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> baseMapper.selectObjs((Wrapper)queryWrapper));
    }

    public static <T, V> List<V> listObjs(AbstractWrapper<T, ?, ?> queryWrapper, SFunction<? super T, V> mapper) {
        return (List)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> baseMapper.selectList((Wrapper)queryWrapper).stream().map(mapper).collect(Collectors.toList()));
    }

    public static <T, V> List<V> listObjs(Class<T> entityClass, SFunction<? super T, V> mapper) {
        return (List)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectList(null).stream().map(mapper).collect(Collectors.toList()));
    }

    public static <T, E extends IPage<Map<String, Object>>> E pageMaps(E page, Class<T> entityClass) {
        return (E)((IPage)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectMapsPage(page, null)));
    }

    public static <T, E extends IPage<Map<String, Object>>> E pageMaps(E page, AbstractWrapper<T, ?, ?> queryWrapper) {
        return (E)((IPage)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> baseMapper.selectMapsPage(page, (Wrapper)queryWrapper)));
    }

    public static <T> IPage<T> page(IPage<T> page, Class<T> entityClass) {
        return (IPage)SqlHelper.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectPage(page, null));
    }

    public static <T> IPage<T> page(IPage<T> page, AbstractWrapper<T, ?, ?> queryWrapper) {
        return (IPage)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> baseMapper.selectPage(page, (Wrapper)queryWrapper));
    }

    public static <T> QueryChainWrapper<T> query(Class<T> entityClass) {
        return ChainWrappers.queryChain(entityClass);
    }

    public static <T> KtQueryChainWrapper<T> ktQuery(Class<T> entityClass) {
        return ChainWrappers.ktQueryChain(entityClass);
    }

    public static <T> LambdaQueryChainWrapper<T> lambdaQuery(Class<T> entityClass) {
        return ChainWrappers.lambdaQueryChain(entityClass);
    }

    public static <T> UpdateChainWrapper<T> update(Class<T> entityClass) {
        return ChainWrappers.updateChain(entityClass);
    }

    public static <T> KtUpdateChainWrapper<T> ktUpdate(Class<T> entityClass) {
        return ChainWrappers.ktUpdateChain(entityClass);
    }

    public static <T> LambdaUpdateChainWrapper<T> lambdaUpdate(Class<T> entityClass) {
        return ChainWrappers.lambdaUpdateChain(entityClass);
    }

    public static <T> boolean saveOrUpdate(T entity, AbstractWrapper<T, ?, ?> updateWrapper) {
        return Db.update(entity, updateWrapper) || Db.saveOrUpdate(entity);
    }

    public static <T, V> V getObj(AbstractWrapper<T, ?, ?> queryWrapper, SFunction<? super T, V> mapper) {
        return (V)SqlHelper.execute(Db.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> mapper.apply(baseMapper.selectOne((Wrapper)queryWrapper)));
    }

    protected static <T> Class<T> getEntityClass(Collection<T> entityList) {
        Class<T> entityClass = null;
        for (T entity : entityList) {
            if (entity == null || entity.getClass() == null) continue;
            entityClass = Db.getEntityClass(entity);
            break;
        }
        Assert.notNull(entityClass, (String)"error: can not get entityClass from entityList", (Object[])new Object[0]);
        return entityClass;
    }

    protected static <T> Class<T> getEntityClass(AbstractWrapper<T, ?, ?> queryWrapper) {
        Object entity;
        Class<Object> entityClass = queryWrapper.getEntityClass();
        if (entityClass == null && (entity = queryWrapper.getEntity()) != null) {
            entityClass = Db.getEntityClass(entity);
        }
        Assert.notNull((Object)entityClass, (String)"error: can not get entityClass from wrapper", (Object[])new Object[0]);
        return entityClass;
    }

    protected static <T> Class<T> getEntityClass(T entity) {
        return entity.getClass();
    }

    protected static <T> TableInfo getTableInfo(Class<T> entityClass) {
        return Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"error: can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
    }
}

