/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.extension.DynamicTableNameHandler;
import com.baomidou.mybatisplus.extension.parser.JsqlParserGlobal;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.UnsupportedStatement;

public class DynamicTableNameJsqlParserInnerInterceptor
extends DynamicTableNameInnerInterceptor {
    private boolean ignoreException = false;
    private boolean shouldFallback = true;

    @Deprecated
    public DynamicTableNameJsqlParserInnerInterceptor() {
    }

    public DynamicTableNameJsqlParserInnerInterceptor(TableNameHandler tableNameHandler) {
        super(tableNameHandler);
    }

    protected String processTableName(String sql) {
        boolean unsupported = false;
        try {
            Statement statement = JsqlParserGlobal.parse(sql);
            statement.accept((StatementVisitor)new DynamicTableNameHandler(sql, super.getTableNameHandler()));
            if (statement instanceof UnsupportedStatement) {
                unsupported = true;
                return super.processTableName(sql);
            }
            return statement.toString();
        }
        catch (Exception exception) {
            return this.handleFallback(unsupported, sql, exception);
        }
    }

    private String handleFallback(boolean unsupported, String sql, Exception originalException) {
        Exception exception = originalException;
        if (!unsupported || this.shouldFallback) {
            try {
                return super.processTableName(sql);
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (this.ignoreException) {
            return sql;
        }
        throw new MybatisPlusException("Table name processing failed : ", (Throwable)exception);
    }

    public void setIgnoreException(boolean ignoreException) {
        this.ignoreException = ignoreException;
    }

    public void setShouldFallback(boolean shouldFallback) {
        this.shouldFallback = shouldFallback;
    }
}

