/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.orm.transaction.TransactionManager;
import java.sql.SQLException;
import org.frameworkset.elasticsearch.client.DataStream;
import org.frameworkset.elasticsearch.client.DefaultResultSetHandler;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.schedule.ScheduleService;
import org.frameworkset.persitent.util.SQLInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2ESDataStreamImpl
extends DataStream {
    private ESJDBC esjdbc;
    private ScheduleService scheduleService;
    private static Logger logger = LoggerFactory.getLogger(DataStream.class);

    @Override
    public void stop() {
        if (this.esjdbc != null) {
            this.esjdbc.stop();
        }
    }

    @Override
    public void execute() throws ESDataImportException {
        if (this.esjdbc == null) {
            throw new ESDataImportException("ESJDBC is null.");
        }
        try {
            this.initES(this.esjdbc.getApplicationPropertiesFile());
            this.initDS(this.esjdbc.getDbConfig());
            this.initSQLInfo();
            this.initSchedule();
            this.importData();
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    private void initSQLInfo() {
        if (this.esjdbc.getSql() == null || this.esjdbc.getSql().equals("")) {
            try {
                ConfigSQLExecutor executor = new ConfigSQLExecutor(this.esjdbc.getSqlFilepath());
                SQLInfo sqlInfo = executor.getSqlInfo(this.esjdbc.getSqlName());
                this.esjdbc.setSql(sqlInfo.getSql());
                this.esjdbc.setExecutor(executor);
            }
            catch (SQLException e) {
                throw new ESDataImportException(e);
            }
        }
    }

    public void setEsjdbc(ESJDBC esjdbc) {
        this.esjdbc = esjdbc;
    }

    private void initSchedule() {
        if (this.esjdbc.getScheduleConfig() != null) {
            this.scheduleService = new ScheduleService();
            this.scheduleService.init(this.esjdbc);
        }
    }

    private void firstImportData() throws Exception {
        DefaultResultSetHandler resultSetHandler = new DefaultResultSetHandler(this.esjdbc, this.esjdbc.getBatchSize());
        if (this.esjdbc.getDataRefactor() == null) {
            if (this.esjdbc.getExecutor() == null) {
                SQLExecutor.queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.esjdbc.getDbConfig().getDbName(), (String)this.esjdbc.getSql(), (Object[])new Object[0]);
            } else {
                this.esjdbc.getExecutor().queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, this.esjdbc.getDbConfig().getDbName(), this.esjdbc.getSqlName(), new Object[0]);
            }
        } else {
            TransactionManager transactionManager = new TransactionManager();
            try {
                transactionManager.begin(TransactionManager.RW_TRANSACTION);
                if (this.esjdbc.getExecutor() == null) {
                    SQLExecutor.queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, (String)this.esjdbc.getDbConfig().getDbName(), (String)this.esjdbc.getSql(), (Object[])new Object[0]);
                } else {
                    this.esjdbc.getExecutor().queryWithDBNameByNullRowHandler((NullRowHandler)resultSetHandler, this.esjdbc.getDbConfig().getDbName(), this.esjdbc.getSqlName(), new Object[0]);
                }
                transactionManager.commit();
            }
            finally {
                transactionManager.releasenolog();
            }
        }
    }

    @Override
    protected void importData() throws Exception {
        if (this.scheduleService == null) {
            this.firstImportData();
        } else {
            this.scheduleService.timeSchedule();
        }
    }
}

