/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.util.SimpleStringUtil;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.BaseBuilder;
import org.frameworkset.elasticsearch.client.DB2ESDataStreamImpl;
import org.frameworkset.elasticsearch.client.DB2ESExportResultHandler;
import org.frameworkset.elasticsearch.client.DBConfig;
import org.frameworkset.elasticsearch.client.DataRefactor;
import org.frameworkset.elasticsearch.client.DataStream;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.EsIdGenerator;
import org.frameworkset.elasticsearch.client.ExportResultHandler;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.IndexPattern;
import org.frameworkset.elasticsearch.client.schedule.CallInterceptor;
import org.frameworkset.elasticsearch.client.schedule.ImportIncreamentConfig;
import org.frameworkset.elasticsearch.client.schedule.ScheduleConfig;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2ESImportBuilder
extends BaseBuilder {
    private static Logger logger = LoggerFactory.getLogger(DB2ESImportBuilder.class);
    protected String sqlFilepath;
    protected boolean pagine;
    protected EsIdGenerator esIdGenerator = ESJDBC.DEFAULT_EsIdGenerator;
    private Boolean useLowcase;
    private String refreshOption;
    private Integer scheduleBatchSize;
    private String index;
    private String indexType;
    private String esIdField;
    private String esParentIdField;
    private String esParentIdValue;
    private String routingField;
    private String routingValue;
    private Boolean esDocAsUpsert;
    private Integer esRetryOnConflict;
    private Boolean esReturnSource;
    private String esVersionField;
    private Object esVersionValue;
    private String esVersionType;
    private Boolean useJavaName;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private ResultSet resultSet;
    private StatementInfo statementInfo;
    private boolean discardBulkResponse = true;
    private boolean debugResponse;
    private ScheduleConfig scheduleConfig;
    private ImportIncreamentConfig importIncreamentConfig;
    private Map<String, FieldMeta> fieldMetaMap = new HashMap<String, FieldMeta>();
    private List<FieldMeta> fieldValues = new ArrayList<FieldMeta>();
    private DataRefactor dataRefactor;

    public boolean isPagine() {
        return this.pagine;
    }

    public DB2ESImportBuilder setPagine(boolean pagine) {
        this.pagine = pagine;
        return this;
    }

    protected DB2ESImportBuilder() {
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public DB2ESImportBuilder setShowSql(boolean showSql) {
        this.showSql = showSql;
        return this;
    }

    public Boolean getUseLowcase() {
        return this.useLowcase;
    }

    public DB2ESImportBuilder setUseLowcase(Boolean useLowcase) {
        this.useLowcase = useLowcase;
        return this;
    }

    public boolean isFreezen() {
        return this.freezen;
    }

    public void setFreezen(boolean freezen) {
        this.freezen = freezen;
    }

    public String getSql() {
        return this.sql;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getValidateSQL() {
        return this.validateSQL;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public String getRefreshOption() {
        return this.refreshOption;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String getEsIdField() {
        return this.esIdField;
    }

    public String getEsParentIdField() {
        return this.esParentIdField;
    }

    public String getRoutingField() {
        return this.routingField;
    }

    public String getRoutingValue() {
        return this.routingValue;
    }

    public Boolean getEsDocAsUpsert() {
        return this.esDocAsUpsert;
    }

    public Integer getEsRetryOnConflict() {
        return this.esRetryOnConflict;
    }

    public Boolean getEsReturnSource() {
        return this.esReturnSource;
    }

    public String getEsVersionField() {
        return this.esVersionField;
    }

    public String getEsVersionType() {
        return this.esVersionType;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public static DB2ESImportBuilder newInstance() {
        return new DB2ESImportBuilder();
    }

    public DB2ESImportBuilder setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        return this;
    }

    public DB2ESImportBuilder setStatementInfo(StatementInfo statementInfo) {
        this.statementInfo = statementInfo;
        return this;
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone));
        return fieldMeta;
    }

    private static FieldMeta buildIgnoreFieldMeta(String dbColumnName) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setIgnore(true);
        return fieldMeta;
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone));
        return fieldMeta;
    }

    public DB2ESImportBuilder addFieldMapping(String dbColumnName, String esFieldName) {
        this.fieldMetaMap.put(dbColumnName.toLowerCase(), this.buildFieldMeta(dbColumnName, esFieldName, null));
        return this;
    }

    public DB2ESImportBuilder addIgnoreFieldMapping(String dbColumnName) {
        DB2ESImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, dbColumnName);
        return this;
    }

    public static void addIgnoreFieldMapping(Map<String, FieldMeta> fieldMetaMap, String dbColumnName) {
        fieldMetaMap.put(dbColumnName.toLowerCase(), DB2ESImportBuilder.buildIgnoreFieldMeta(dbColumnName));
    }

    public DB2ESImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat) {
        this.fieldMetaMap.put(dbColumnName.toLowerCase(), this.buildFieldMeta(dbColumnName, esFieldName, dateFormat));
        return this;
    }

    public DB2ESImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        this.fieldMetaMap.put(dbColumnName.toLowerCase(), this.buildFieldMeta(dbColumnName, esFieldName, dateFormat, locale, timeZone));
        return this;
    }

    public DB2ESImportBuilder setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public DB2ESImportBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public DB2ESImportBuilder setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public DB2ESImportBuilder setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
        return this;
    }

    public DB2ESImportBuilder setEsVersionType(String esVersionType) {
        this.esVersionType = esVersionType;
        return this;
    }

    public DB2ESImportBuilder setEsVersionField(String esVersionField) {
        this.esVersionField = esVersionField;
        return this;
    }

    public DB2ESImportBuilder setEsReturnSource(Boolean esReturnSource) {
        this.esReturnSource = esReturnSource;
        return this;
    }

    public DB2ESImportBuilder setEsRetryOnConflict(Integer esRetryOnConflict) {
        this.esRetryOnConflict = esRetryOnConflict;
        return this;
    }

    public DB2ESImportBuilder setEsDocAsUpsert(Boolean esDocAsUpsert) {
        this.esDocAsUpsert = esDocAsUpsert;
        return this;
    }

    public DB2ESImportBuilder setRoutingValue(String routingValue) {
        this.routingValue = routingValue;
        return this;
    }

    public DB2ESImportBuilder setRoutingField(String routingField) {
        this.routingField = routingField;
        return this;
    }

    public DB2ESImportBuilder setEsParentIdField(String esParentIdField) {
        this.esParentIdField = esParentIdField;
        return this;
    }

    public DB2ESImportBuilder setEsIdField(String esIdField) {
        this.esIdField = esIdField;
        return this;
    }

    private ESJDBC buildESJDBCConfig() {
        ESJDBC esjdbcResultSet = new ESJDBC();
        esjdbcResultSet.setImportBuilder(this);
        esjdbcResultSet.setDateFormat(this.dateFormat);
        esjdbcResultSet.setLocale(this.locale);
        esjdbcResultSet.setTimeZone(this.timeZone);
        esjdbcResultSet.setEsDocAsUpsert(this.esDocAsUpsert);
        esjdbcResultSet.setEsIdField(this.esIdField);
        esjdbcResultSet.setEsParentIdField(this.esParentIdField);
        esjdbcResultSet.setEsParentIdValue(this.esParentIdValue);
        esjdbcResultSet.setEsRetryOnConflict(this.esRetryOnConflict);
        esjdbcResultSet.setEsReturnSource(this.esReturnSource);
        esjdbcResultSet.setEsVersionField(this.esVersionField);
        esjdbcResultSet.setEsVersionValue(this.esVersionValue);
        esjdbcResultSet.setEsVersionType(this.esVersionType);
        esjdbcResultSet.setRoutingField(this.routingField);
        esjdbcResultSet.setRoutingValue(this.routingValue);
        esjdbcResultSet.setUseJavaName(this.useJavaName);
        esjdbcResultSet.setFieldMetaMap(this.fieldMetaMap);
        esjdbcResultSet.setFieldValues(this.fieldValues);
        esjdbcResultSet.setDataRefactor(this.dataRefactor);
        esjdbcResultSet.setSqlFilepath(this.sqlFilepath);
        esjdbcResultSet.setSqlName(this.sqlName);
        if (SimpleStringUtil.isNotEmpty((String)this.sql)) {
            esjdbcResultSet.setSql(this.sql);
        }
        DBConfig dbConfig = new DBConfig();
        esjdbcResultSet.setDbConfig(dbConfig);
        dbConfig.setDbName(this.dbName);
        dbConfig.setShowSql(this.showSql);
        esjdbcResultSet.setRefreshOption(this.refreshOption);
        esjdbcResultSet.setBatchSize(this.batchSize);
        dbConfig.setJdbcFetchSize(this.jdbcFetchSize);
        esjdbcResultSet.setIndex(this.index);
        esjdbcResultSet.setIndexPattern(this.splitIndexName(this.index));
        esjdbcResultSet.setIndexType(this.indexType);
        dbConfig.setDbDriver(this.dbDriver);
        dbConfig.setDbUrl(this.dbUrl);
        dbConfig.setDbUser(this.dbUser);
        dbConfig.setDbPassword(this.dbPassword);
        dbConfig.setValidateSQL(this.validateSQL);
        dbConfig.setUsePool(this.usePool);
        esjdbcResultSet.setApplicationPropertiesFile(this.applicationPropertiesFile);
        esjdbcResultSet.setParallel(this.parallel);
        esjdbcResultSet.setThreadCount(this.threadCount);
        esjdbcResultSet.setQueue(this.queue);
        esjdbcResultSet.setAsyn(this.asyn);
        esjdbcResultSet.setContinueOnError(this.continueOnError);
        esjdbcResultSet.setDiscardBulkResponse(this.discardBulkResponse);
        esjdbcResultSet.setDebugResponse(this.debugResponse);
        esjdbcResultSet.setScheduleConfig(this.scheduleConfig);
        esjdbcResultSet.setImportIncreamentConfig(this.importIncreamentConfig);
        if (this.scheduleBatchSize != null) {
            esjdbcResultSet.setScheduleBatchSize(this.scheduleBatchSize);
        } else {
            esjdbcResultSet.setScheduleBatchSize(this.batchSize);
        }
        esjdbcResultSet.setCallInterceptors(this.callInterceptors);
        esjdbcResultSet.setUseLowcase(this.useLowcase);
        esjdbcResultSet.setPrintTaskLog(this.printTaskLog);
        esjdbcResultSet.setEsIdGenerator(this.esIdGenerator);
        if (this.exportResultHandler != null) {
            DB2ESExportResultHandler db2ESExportResultHandler = new DB2ESExportResultHandler(this.exportResultHandler);
            esjdbcResultSet.setExportResultHandler(db2ESExportResultHandler);
        }
        esjdbcResultSet.setPagine(this.pagine);
        return esjdbcResultSet;
    }

    public DataStream builder() {
        this.buildDBConfig();
        try {
            logger.info("DB2ES Import Configs:");
            logger.info(this.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ESJDBC esjdbcResultSet = this.buildESJDBCConfig();
        DB2ESDataStreamImpl dataStream = new DB2ESDataStreamImpl();
        dataStream.setEsjdbc(esjdbcResultSet);
        return dataStream;
    }

    public DB2ESImportBuilder setIndexType(String indexType) {
        this.indexType = indexType;
        return this;
    }

    public DB2ESImportBuilder setIndex(String index) {
        this.index = index;
        return this;
    }

    public DB2ESImportBuilder setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public DB2ESImportBuilder setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
        return this;
    }

    public DB2ESImportBuilder setDbName(String dbName) {
        this.freezen = true;
        this.dbName = dbName;
        return this;
    }

    public DB2ESImportBuilder setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public DB2ESImportBuilder setDbDriver(String dbDriver) {
        this.freezen = true;
        this.dbDriver = dbDriver;
        return this;
    }

    public DB2ESImportBuilder setDbUrl(String dbUrl) {
        this.freezen = true;
        this.dbUrl = dbUrl;
        return this;
    }

    public DB2ESImportBuilder setDbUser(String dbUser) {
        this.freezen = true;
        this.dbUser = dbUser;
        return this;
    }

    public DB2ESImportBuilder setDbPassword(String dbPassword) {
        this.freezen = true;
        this.dbPassword = dbPassword;
        return this;
    }

    public DB2ESImportBuilder setValidateSQL(String validateSQL) {
        this.freezen = true;
        this.validateSQL = validateSQL;
        return this;
    }

    public DB2ESImportBuilder setUsePool(boolean usePool) {
        this.freezen = true;
        this.usePool = usePool;
        return this;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public DB2ESImportBuilder setParallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public DB2ESImportBuilder setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public DB2ESImportBuilder setAsyn(boolean asyn) {
        this.asyn = asyn;
        return this;
    }

    public DB2ESImportBuilder setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    public DB2ESImportBuilder addFieldValue(String fieldName, Object value) {
        DB2ESImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        return this;
    }

    public DB2ESImportBuilder addFieldValue(String fieldName, String dateFormat, Object value) {
        DB2ESImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.locale, this.timeZone);
        return this;
    }

    public DB2ESImportBuilder addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        DB2ESImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        return this;
    }

    public static void addFieldValue(List<FieldMeta> fieldValues, String fieldName, Object value) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setEsFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldValues.add(fieldMeta);
    }

    public static void addFieldValue(List<FieldMeta> fieldValues, String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setEsFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldMeta.setDateFormateMeta(DB2ESImportBuilder.buildDateFormateMeta(dateFormat, locale, timeZone));
        fieldValues.add(fieldMeta);
    }

    public DateFormateMeta buildDateFormateMeta(String dateFormat) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public static DateFormateMeta buildDateFormateMeta(String dateFormat, String locale, String timeZone) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone);
    }

    public DataRefactor getDataRefactor() {
        return this.dataRefactor;
    }

    public DB2ESImportBuilder setDataRefactor(DataRefactor dataRefactor) {
        this.dataRefactor = dataRefactor;
        return this;
    }

    public String getEsParentIdValue() {
        return this.esParentIdValue;
    }

    public void setEsParentIdValue(String esParentIdValue) {
        this.esParentIdValue = esParentIdValue;
    }

    public Object getEsVersionValue() {
        return this.esVersionValue;
    }

    public DB2ESImportBuilder setEsVersionValue(Object esVersionValue) {
        this.esVersionValue = esVersionValue;
        return this;
    }

    public boolean isDiscardBulkResponse() {
        return this.discardBulkResponse;
    }

    public DB2ESImportBuilder setDiscardBulkResponse(boolean discardBulkResponse) {
        this.discardBulkResponse = discardBulkResponse;
        return this;
    }

    public boolean isDebugResponse() {
        return this.debugResponse;
    }

    public DB2ESImportBuilder setDebugResponse(boolean debugResponse) {
        this.debugResponse = debugResponse;
        return this;
    }

    public DB2ESImportBuilder setPeriod(Long period) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setPeriod(period);
        return this;
    }

    public DB2ESImportBuilder setDeyLay(Long deyLay) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setDeyLay(deyLay);
        return this;
    }

    public DB2ESImportBuilder setScheduleDate(Date scheduleDate) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setScheduleDate(scheduleDate);
        return this;
    }

    public DB2ESImportBuilder setFixedRate(Boolean fixedRate) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setFixedRate(fixedRate);
        return this;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public ImportIncreamentConfig getImportIncreamentConfig() {
        return this.importIncreamentConfig;
    }

    public DB2ESImportBuilder setDateLastValueColumn(String dateLastValueColumn) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setDateLastValueColumn(dateLastValueColumn);
        return this;
    }

    public DB2ESImportBuilder setNumberLastValueColumn(String numberLastValueColumn) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setNumberLastValueColumn(numberLastValueColumn);
        return this;
    }

    public DB2ESImportBuilder setLastValueStorePath(String lastValueStorePath) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStorePath(lastValueStorePath);
        return this;
    }

    public DB2ESImportBuilder setLastValueStoreTableName(String lastValueStoreTableName) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStoreTableName(lastValueStoreTableName);
        return this;
    }

    public DB2ESImportBuilder setFromFirst(boolean fromFirst) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setFromFirst(fromFirst);
        return this;
    }

    public DB2ESImportBuilder setLastValue(Long lastValue) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValue(lastValue);
        return this;
    }

    public DB2ESImportBuilder setLastValueType(int lastValueType) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueType(lastValueType);
        return this;
    }

    public DB2ESImportBuilder setSqlFilepath(String sqlFilepath) {
        this.sqlFilepath = sqlFilepath;
        return this;
    }

    public DB2ESImportBuilder setJdbcFetchSize(Integer jdbcFetchSize) {
        this.jdbcFetchSize = jdbcFetchSize;
        return this;
    }

    public Integer getScheduleBatchSize() {
        return this.scheduleBatchSize;
    }

    public DB2ESImportBuilder setScheduleBatchSize(Integer scheduleBatchSize) {
        this.scheduleBatchSize = scheduleBatchSize;
        return this;
    }

    public DB2ESImportBuilder addCallInterceptor(CallInterceptor interceptor) {
        if (this.callInterceptors == null) {
            this.callInterceptors = new ArrayList();
        }
        this.callInterceptors.add(interceptor);
        return this;
    }

    public boolean isPrintTaskLog() {
        return this.printTaskLog;
    }

    public DB2ESImportBuilder setPrintTaskLog(boolean printTaskLog) {
        this.printTaskLog = printTaskLog;
        return this;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(SimpleStringUtil.object2json((Object)this));
        return ret.toString();
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public DB2ESImportBuilder setSqlName(String sqlName) {
        this.sqlName = sqlName;
        return this;
    }

    public DB2ESImportBuilder setEsIdGenerator(EsIdGenerator esIdGenerator) {
        if (esIdGenerator != null) {
            this.esIdGenerator = esIdGenerator;
        }
        return this;
    }

    private IndexPattern splitIndexName(String indexPattern) {
        int idx = indexPattern.indexOf("{");
        int end = -1;
        if (idx > 0) {
            end = indexPattern.indexOf("}");
            IndexPattern _indexPattern = new IndexPattern();
            _indexPattern.setIndexPrefix(indexPattern.substring(0, idx));
            _indexPattern.setDateFormat(indexPattern.substring(idx + 1, end));
            if (end < indexPattern.length()) {
                _indexPattern.setIndexEnd(indexPattern.substring(end + 1));
            }
            return _indexPattern;
        }
        return null;
    }

    public ExportResultHandler getExportResultHandler() {
        return this.exportResultHandler;
    }

    public DB2ESImportBuilder setExportResultHandler(ExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
        return this;
    }
}

