/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.util.SimpleStringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.BaseBuilder;
import org.frameworkset.elasticsearch.client.DBConfig;
import org.frameworkset.elasticsearch.client.DataStream;
import org.frameworkset.elasticsearch.client.ExportResultHandler;
import org.frameworkset.elasticsearch.client.estodb.ES2DB;
import org.frameworkset.elasticsearch.client.estodb.ES2DBDataStreamImpl;
import org.frameworkset.elasticsearch.client.schedule.CallInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ES2DBExportBuilder
extends BaseBuilder {
    private static Logger logger = LoggerFactory.getLogger(ES2DBExportBuilder.class);
    private Integer insertBatchSize;
    private String scrollLiveTime = "100m";
    private BatchHandler<Map> batchHandler;
    private Map params;
    private String queryUrl;
    private String dsl2ndSqlFile;
    private String dslName;
    private boolean sliceQuery;
    private int sliceSize;

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(SimpleStringUtil.object2json((Object)this));
        return ret.toString();
    }

    private ES2DB buildES2DBConfig() {
        ES2DB es2DB = new ES2DB();
        es2DB.setDsl2ndSqlFile(this.dsl2ndSqlFile);
        es2DB.setSqlName(this.sqlName);
        es2DB.setSql(this.sql);
        DBConfig dbConfig = new DBConfig();
        es2DB.setDbConfig(dbConfig);
        dbConfig.setDbName(this.dbName);
        dbConfig.setShowSql(this.showSql);
        es2DB.setBatchSize(this.batchSize);
        dbConfig.setJdbcFetchSize(this.jdbcFetchSize);
        es2DB.setQueryUrl(this.queryUrl);
        es2DB.setScrollLiveTime(this.scrollLiveTime);
        dbConfig.setDbDriver(this.dbDriver);
        dbConfig.setDbUrl(this.dbUrl);
        dbConfig.setDbUser(this.dbUser);
        dbConfig.setDbPassword(this.dbPassword);
        dbConfig.setValidateSQL(this.validateSQL);
        dbConfig.setUsePool(this.usePool);
        es2DB.setApplicationPropertiesFile(this.applicationPropertiesFile);
        es2DB.setParallel(this.parallel);
        es2DB.setThreadCount(this.threadCount);
        es2DB.setQueue(this.queue);
        es2DB.setAsyn(this.asyn);
        es2DB.setContinueOnError(this.continueOnError);
        es2DB.setBatchSize(this.batchSize);
        es2DB.setInsertBatchSize(this.insertBatchSize);
        es2DB.setBatchHandler(this.batchHandler);
        es2DB.setDslName(this.dslName);
        es2DB.setSliceQuery(this.sliceQuery);
        es2DB.setSliceSize(this.sliceSize);
        es2DB.setParams(this.params);
        return es2DB;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public ES2DBExportBuilder setParallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    public DataStream builder() {
        this.buildDBConfig();
        try {
            logger.info("ES2DB Import Configs:");
            logger.info(this.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ES2DB esjdbcResultSet = this.buildES2DBConfig();
        ES2DBDataStreamImpl dataStream = new ES2DBDataStreamImpl();
        dataStream.setEs2DB(esjdbcResultSet);
        return dataStream;
    }

    public boolean isPrintTaskLog() {
        return this.printTaskLog;
    }

    public ES2DBExportBuilder setPrintTaskLog(boolean printTaskLog) {
        this.printTaskLog = printTaskLog;
        return this;
    }

    public List<CallInterceptor> getCallInterceptors() {
        return this.callInterceptors;
    }

    public ES2DBExportBuilder setCallInterceptors(List<CallInterceptor> callInterceptors) {
        this.callInterceptors = callInterceptors;
        return this;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public ES2DBExportBuilder setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
        return this;
    }

    public boolean isFreezen() {
        return this.freezen;
    }

    public ES2DBExportBuilder setFreezen(boolean freezen) {
        this.freezen = freezen;
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public ES2DBExportBuilder setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public ES2DBExportBuilder setSqlName(String sqlName) {
        this.sqlName = sqlName;
        return this;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public ES2DBExportBuilder setShowSql(boolean showSql) {
        this.showSql = showSql;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public ES2DBExportBuilder setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public ES2DBExportBuilder setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
        return this;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public ES2DBExportBuilder setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
        return this;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public ES2DBExportBuilder setDbUser(String dbUser) {
        this.dbUser = dbUser;
        return this;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public ES2DBExportBuilder setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
        return this;
    }

    public String getValidateSQL() {
        return this.validateSQL;
    }

    public ES2DBExportBuilder setValidateSQL(String validateSQL) {
        this.validateSQL = validateSQL;
        return this;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public ES2DBExportBuilder setUsePool(boolean usePool) {
        this.usePool = usePool;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public ES2DBExportBuilder setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Integer getInsertBatchSize() {
        return this.insertBatchSize;
    }

    public ES2DBExportBuilder setInsertBatchSize(Integer insertBatchSize) {
        this.insertBatchSize = insertBatchSize;
        return this;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public ES2DBExportBuilder setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
        return this;
    }

    public BatchHandler<Map> getBatchHandler() {
        return this.batchHandler;
    }

    public ES2DBExportBuilder setBatchHandler(BatchHandler<Map> batchHandler) {
        this.batchHandler = batchHandler;
        return this;
    }

    public String getDsl2ndSqlFile() {
        return this.dsl2ndSqlFile;
    }

    public ES2DBExportBuilder setDsl2ndSqlFile(String dsl2ndSqlFile) {
        this.dsl2ndSqlFile = dsl2ndSqlFile;
        return this;
    }

    public String getDslName() {
        return this.dslName;
    }

    public ES2DBExportBuilder setDslName(String dslName) {
        this.dslName = dslName;
        return this;
    }

    public String getScrollLiveTime() {
        return this.scrollLiveTime;
    }

    public ES2DBExportBuilder setScrollLiveTime(String scrollLiveTime) {
        this.scrollLiveTime = scrollLiveTime;
        return this;
    }

    public boolean isSliceQuery() {
        return this.sliceQuery;
    }

    public ES2DBExportBuilder setSliceQuery(boolean sliceQuery) {
        this.sliceQuery = sliceQuery;
        return this;
    }

    public int getSliceSize() {
        return this.sliceSize;
    }

    public ES2DBExportBuilder setSliceSize(int sliceSize) {
        this.sliceSize = sliceSize;
        return this;
    }

    public ES2DBExportBuilder addParam(String key, Object value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        this.params.put(key, value);
        return this;
    }

    public ExportResultHandler getExportResultHandler() {
        return this.exportResultHandler;
    }

    public ES2DBExportBuilder setExportResultHandler(ExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
        return this;
    }
}

