/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.db2es;

import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.TaskCommand;
import org.frameworkset.elasticsearch.client.TaskFailedException;
import org.frameworkset.elasticsearch.handler.ESVoidResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCommandImpl
implements TaskCommand<String, String> {
    private String refreshOption;
    private ClientInterface clientInterface;
    private String datas;
    private ESJDBC esjdbc;
    private int tryCount;
    private static Logger logger = LoggerFactory.getLogger(TaskCommand.class);

    public String getRefreshOption() {
        return this.refreshOption;
    }

    public ClientInterface getClientInterface() {
        return this.clientInterface;
    }

    @Override
    public String getDatas() {
        return this.datas;
    }

    public ESJDBC getEsjdbc() {
        return this.esjdbc;
    }

    public void setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
    }

    public void setClientInterface(ClientInterface clientInterface) {
        this.clientInterface = clientInterface;
    }

    @Override
    public void setDatas(String datas) {
        this.datas = datas;
    }

    public void setEsjdbc(ESJDBC esjdbc) {
        this.esjdbc = esjdbc;
    }

    @Override
    public String execute() {
        String data = null;
        if (this.esjdbc.getMaxRetry() > 0 && this.tryCount >= this.esjdbc.getMaxRetry()) {
            throw new TaskFailedException("task execute failed:reached max retry times " + this.esjdbc.getMaxRetry());
        }
        ++this.tryCount;
        if (this.esjdbc.isDebugResponse()) {
            if (this.refreshOption == null) {
                data = this.clientInterface.executeHttp("_bulk", this.datas, "post");
                logger.info(data);
            } else {
                data = this.clientInterface.executeHttp("_bulk?" + this.refreshOption, this.datas, "post");
                logger.info(data);
            }
        } else {
            if (this.esjdbc.isDiscardBulkResponse() && this.esjdbc.getExportResultHandler() == null) {
                ESVoidResponseHandler esVoidResponseHandler = new ESVoidResponseHandler();
                if (this.refreshOption == null) {
                    this.clientInterface.executeHttp("_bulk", this.datas, "post", (ResponseHandler)esVoidResponseHandler);
                } else {
                    this.clientInterface.executeHttp("_bulk?" + this.refreshOption, this.datas, "post", (ResponseHandler)esVoidResponseHandler);
                }
                if (esVoidResponseHandler.getElasticSearchException() != null) {
                    throw esVoidResponseHandler.getElasticSearchException();
                }
                return null;
            }
            data = this.refreshOption == null ? this.clientInterface.executeHttp("_bulk", this.datas, "post") : this.clientInterface.executeHttp("_bulk?" + this.refreshOption, this.datas, "post");
        }
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

