/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.config.BaseImportConfig;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataStream {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ImportContext importContext;
    protected BaseImportConfig importConfig;
    private boolean inited;
    private Lock lock = new ReentrantLock();
    private String configString;

    protected abstract ImportContext buildImportContext(BaseImportConfig var1);

    public void execute() throws ESDataImportException {
        try {
            this.init();
            this.importContext.importData();
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    public void destroy() {
        if (this.importContext != null) {
            this.importContext.destroy();
        }
    }

    public String getConfigString() {
        return this.configString;
    }

    public void setConfigString(String configString) {
        this.configString = configString;
    }

    public void init() {
        if (this.inited) {
            this.importContext.resume();
            return;
        }
        if (this.importConfig == null) {
            throw new ESDataImportException("import Config is null.");
        }
        try {
            this.lock.lock();
            this.importContext = this.buildImportContext(this.importConfig);
            this.inited = true;
        }
        catch (Exception e) {
            this.inited = true;
            throw new ESDataImportException(e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

