/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.config;

import com.frameworkset.orm.annotation.ESIndexWrapper;
import com.frameworkset.util.SimpleStringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.DBConfig;
import org.frameworkset.elasticsearch.client.DataRefactor;
import org.frameworkset.elasticsearch.client.DataStream;
import org.frameworkset.elasticsearch.client.EsIdGenerator;
import org.frameworkset.elasticsearch.client.ExportResultHandler;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.WrapedExportResultHandler;
import org.frameworkset.elasticsearch.client.config.BaseImportConfig;
import org.frameworkset.elasticsearch.client.db2es.DB2ESImportConfig;
import org.frameworkset.elasticsearch.client.schedule.CallInterceptor;
import org.frameworkset.elasticsearch.client.schedule.ImportIncreamentConfig;
import org.frameworkset.elasticsearch.client.schedule.ScheduleConfig;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.util.annotations.DateFormateMeta;

public abstract class BaseImportBuilder {
    private DBConfig dbConfig;
    private DBConfig statusDbConfig;
    private Integer fetchSize = 5000;
    private boolean sortLastValue = true;
    private boolean discardBulkResponse = true;
    private boolean debugResponse;
    private ScheduleConfig scheduleConfig;
    private ImportIncreamentConfig importIncreamentConfig;
    private boolean externalTimer;
    private boolean printTaskLog = false;
    private List<CallInterceptor> callInterceptors;
    private String applicationPropertiesFile;
    private boolean freezen;
    private boolean statusFreezen;
    private List<DBConfig> configs;
    private boolean dropIndice;
    private int batchSize = 1000;
    private boolean parallel;
    private int threadCount = 200;
    private int queue = 1000;
    private boolean asyn;
    private boolean continueOnError;
    private Boolean useLowcase;
    private String refreshOption;
    private Integer scheduleBatchSize;
    private String index;
    private String indexType;
    private String esIdField;
    private String esParentIdField;
    private String esParentIdValue;
    private String routingField;
    private String routingValue;
    private Boolean esDocAsUpsert;
    private Integer esRetryOnConflict;
    private Boolean esReturnSource;
    private String esVersionField;
    private Object esVersionValue;
    private String esVersionType;
    private Boolean useJavaName;
    protected ExportResultHandler exportResultHandler;
    private String configString;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private EsIdGenerator esIdGenerator = DB2ESImportConfig.DEFAULT_EsIdGenerator;
    private Map<String, FieldMeta> fieldMetaMap = new HashMap<String, FieldMeta>();
    private List<FieldMeta> fieldValues = new ArrayList<FieldMeta>();
    private DataRefactor dataRefactor;
    private boolean pagine;

    public boolean isSortLastValue() {
        return this.sortLastValue;
    }

    public BaseImportBuilder setSortLastValue(boolean sortLastValue) {
        this.sortLastValue = sortLastValue;
        return this;
    }

    public boolean isExternalTimer() {
        return this.externalTimer;
    }

    public Boolean getUseLowcase() {
        return this.useLowcase;
    }

    public BaseImportBuilder setUseLowcase(Boolean useLowcase) {
        this.useLowcase = useLowcase;
        return this;
    }

    protected void buildDBConfig() {
        if (!this.freezen) {
            PropertiesContainer propertiesContainer = new PropertiesContainer();
            if (this.applicationPropertiesFile == null) {
                propertiesContainer.addConfigPropertiesFile("application.properties");
            } else {
                propertiesContainer.addConfigPropertiesFile(this.applicationPropertiesFile);
            }
            String dbName = propertiesContainer.getProperty("db.name");
            if (dbName == null || dbName.equals("")) {
                return;
            }
            this.dbConfig = new DBConfig();
            this._buildDBConfig(propertiesContainer, dbName, this.dbConfig, "");
        }
    }

    public ExportResultHandler getExportResultHandler() {
        return this.exportResultHandler;
    }

    public BaseImportBuilder setExportResultHandler(ExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
        return this;
    }

    public boolean isDropIndice() {
        return this.dropIndice;
    }

    public void setDropIndice(boolean dropIndice) {
        this.dropIndice = dropIndice;
    }

    public BaseImportBuilder setEsIdGenerator(EsIdGenerator esIdGenerator) {
        if (esIdGenerator != null) {
            this.esIdGenerator = esIdGenerator;
        }
        return this;
    }

    protected void buildStatusDBConfig() {
        if (!this.statusFreezen) {
            PropertiesContainer propertiesContainer = new PropertiesContainer();
            String prefix = "config.";
            if (this.applicationPropertiesFile == null) {
                propertiesContainer.addConfigPropertiesFile("application.properties");
            } else {
                propertiesContainer.addConfigPropertiesFile(this.applicationPropertiesFile);
            }
            String dbName = propertiesContainer.getProperty(prefix + "db.name");
            if (dbName == null || dbName.equals("")) {
                return;
            }
            this.statusDbConfig = new DBConfig();
            this._buildDBConfig(propertiesContainer, dbName, this.statusDbConfig, "config.");
        }
    }

    protected void builderConfig() {
        this.buildDBConfig();
        this.buildStatusDBConfig();
        this.buildOtherDBConfigs();
    }

    protected void buildOtherDBConfigs() {
        PropertiesContainer propertiesContainer = new PropertiesContainer();
        if (this.applicationPropertiesFile == null) {
            propertiesContainer.addConfigPropertiesFile("application.properties");
        } else {
            propertiesContainer.addConfigPropertiesFile(this.applicationPropertiesFile);
        }
        String thirdDatasources = propertiesContainer.getProperty("thirdDatasources");
        if (thirdDatasources == null || thirdDatasources.equals("")) {
            return;
        }
        String[] names = thirdDatasources.split(",");
        ArrayList<DBConfig> configs = new ArrayList<DBConfig>();
        for (int i = 0; i < names.length; ++i) {
            String prefix = names[i].trim();
            if (prefix.equals("")) continue;
            DBConfig statusDbConfig = new DBConfig();
            this._buildDBConfig(propertiesContainer, prefix, statusDbConfig, prefix + ".");
            configs.add(statusDbConfig);
        }
        this.configs = configs;
    }

    protected void _buildDBConfig(PropertiesContainer propertiesContainer, String dbName, DBConfig dbConfig, String prefix) {
        String _maxSize;
        String _minIdleSize;
        String _initSize;
        String _jdbcFetchSize;
        dbConfig.setDbName(dbName);
        String dbUser = propertiesContainer.getProperty(prefix + "db.user");
        dbConfig.setDbUser(dbUser);
        String dbPassword = propertiesContainer.getProperty(prefix + "db.password");
        dbConfig.setDbPassword(dbPassword);
        String dbDriver = propertiesContainer.getProperty(prefix + "db.driver");
        dbConfig.setDbDriver(dbDriver);
        boolean enableDBTransaction = propertiesContainer.getBooleanProperty(prefix + "db.enableDBTransaction", false);
        dbConfig.setEnableDBTransaction(enableDBTransaction);
        String dbUrl = propertiesContainer.getProperty(prefix + "db.url");
        dbConfig.setDbUrl(dbUrl);
        String _usePool = propertiesContainer.getProperty(prefix + "db.usePool");
        if (_usePool != null && !_usePool.equals("")) {
            boolean usePool = Boolean.parseBoolean(_usePool);
            dbConfig.setUsePool(usePool);
        }
        String validateSQL = propertiesContainer.getProperty(prefix + "db.validateSQL");
        dbConfig.setValidateSQL(validateSQL);
        String _showSql = propertiesContainer.getProperty(prefix + "db.showsql");
        if (_showSql != null && !_showSql.equals("")) {
            boolean showSql = Boolean.parseBoolean(_showSql);
            dbConfig.setShowSql(showSql);
        }
        if ((_jdbcFetchSize = propertiesContainer.getProperty(prefix + "db.jdbcFetchSize")) != null && !_jdbcFetchSize.equals("")) {
            int jdbcFetchSize = Integer.parseInt(_jdbcFetchSize);
            dbConfig.setJdbcFetchSize(jdbcFetchSize);
        }
        if ((_initSize = propertiesContainer.getProperty(prefix + "db.initSize")) != null && !_initSize.equals("")) {
            int initSize = Integer.parseInt(_initSize);
            dbConfig.setInitSize(initSize);
        }
        if ((_minIdleSize = propertiesContainer.getProperty(prefix + "db.minIdleSize")) != null && !_minIdleSize.equals("")) {
            int minIdleSize = Integer.parseInt(_minIdleSize);
            dbConfig.setMinIdleSize(minIdleSize);
        }
        if ((_maxSize = propertiesContainer.getProperty(prefix + "db.maxSize")) != null && !_maxSize.equals("")) {
            int maxSize = Integer.parseInt(_maxSize);
            dbConfig.setMaxSize(maxSize);
        }
        String statusTableDML = propertiesContainer.getProperty(prefix + "db.statusTableDML");
        dbConfig.setStatusTableDML(statusTableDML);
        String dbAdaptor = propertiesContainer.getProperty(prefix + "db.dbAdaptor");
        dbConfig.setDbAdaptor(dbAdaptor);
        String dbtype = propertiesContainer.getProperty(prefix + "db.dbtype");
        dbConfig.setDbtype(dbtype);
    }

    public String getDbName() {
        return this.dbConfig.getDbName();
    }

    public String getDbDriver() {
        return this.dbConfig.getDbDriver();
    }

    public String getDbUrl() {
        return this.dbConfig.getDbUrl();
    }

    public String getDbUser() {
        return this.dbConfig.getDbUser();
    }

    public String getDbPassword() {
        return this.dbConfig.getDbPassword();
    }

    public String getValidateSQL() {
        return this.dbConfig.getValidateSQL();
    }

    public boolean isUsePool() {
        return this.dbConfig.isUsePool();
    }

    public boolean isShowSql() {
        return this.dbConfig.isShowSql();
    }

    protected void _setJdbcFetchSize(Integer jdbcFetchSize) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setJdbcFetchSize(jdbcFetchSize);
    }

    public void _setDbPassword(String dbPassword) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbPassword(dbPassword);
    }

    public BaseImportBuilder setDbName(String dbName) {
        this._setDbName(dbName);
        return this;
    }

    public BaseImportBuilder setDbDriver(String dbDriver) {
        this._setDbDriver(dbDriver);
        return this;
    }

    public BaseImportBuilder setEnableDBTransaction(boolean enableDBTransaction) {
        this._setEnableDBTransaction(enableDBTransaction);
        return this;
    }

    public BaseImportBuilder setDbUrl(String dbUrl) {
        this._setDbUrl(dbUrl);
        return this;
    }

    public BaseImportBuilder setDbAdaptor(String dbAdaptor) {
        this._setDbAdaptor(dbAdaptor);
        return this;
    }

    public BaseImportBuilder setDbtype(String dbtype) {
        this._setDbtype(dbtype);
        return this;
    }

    public BaseImportBuilder setDbUser(String dbUser) {
        this._setDbUser(dbUser);
        return this;
    }

    public BaseImportBuilder setDbPassword(String dbPassword) {
        this._setDbPassword(dbPassword);
        return this;
    }

    public BaseImportBuilder setValidateSQL(String validateSQL) {
        this._setValidateSQL(validateSQL);
        return this;
    }

    public BaseImportBuilder setUsePool(boolean usePool) {
        this._setUsePool(usePool);
        return this;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public BaseImportBuilder setParallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public BaseImportBuilder setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public BaseImportBuilder setAsyn(boolean asyn) {
        this.asyn = asyn;
        return this;
    }

    public BaseImportBuilder setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    public String getEsParentIdValue() {
        return this.esParentIdValue;
    }

    public void setEsParentIdValue(String esParentIdValue) {
        this.esParentIdValue = esParentIdValue;
    }

    public Object getEsVersionValue() {
        return this.esVersionValue;
    }

    public BaseImportBuilder setEsVersionValue(Object esVersionValue) {
        this.esVersionValue = esVersionValue;
        return this;
    }

    public boolean isDiscardBulkResponse() {
        return this.discardBulkResponse;
    }

    public BaseImportBuilder setDiscardBulkResponse(boolean discardBulkResponse) {
        this.discardBulkResponse = discardBulkResponse;
        return this;
    }

    public boolean isDebugResponse() {
        return this.debugResponse;
    }

    public BaseImportBuilder setDebugResponse(boolean debugResponse) {
        this.debugResponse = debugResponse;
        return this;
    }

    public BaseImportBuilder setPeriod(Long period) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setPeriod(period);
        return this;
    }

    public BaseImportBuilder setDeyLay(Long deyLay) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setDeyLay(deyLay);
        return this;
    }

    public BaseImportBuilder setScheduleDate(Date scheduleDate) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setScheduleDate(scheduleDate);
        return this;
    }

    public BaseImportBuilder setFixedRate(Boolean fixedRate) {
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setFixedRate(fixedRate);
        return this;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public ImportIncreamentConfig getImportIncreamentConfig() {
        return this.importIncreamentConfig;
    }

    public BaseImportBuilder setDateLastValueColumn(String dateLastValueColumn) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setDateLastValueColumn(dateLastValueColumn);
        return this;
    }

    public BaseImportBuilder setNumberLastValueColumn(String numberLastValueColumn) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setNumberLastValueColumn(numberLastValueColumn);
        return this;
    }

    public BaseImportBuilder setLastValueStorePath(String lastValueStorePath) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStorePath(lastValueStorePath);
        return this;
    }

    public BaseImportBuilder setLastValueStoreTableName(String lastValueStoreTableName) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueStoreTableName(lastValueStoreTableName);
        return this;
    }

    public BaseImportBuilder setFromFirst(boolean fromFirst) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setFromFirst(fromFirst);
        return this;
    }

    public BaseImportBuilder setLastValue(Object lastValue) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValue(lastValue);
        return this;
    }

    public BaseImportBuilder setLastValueType(int lastValueType) {
        if (this.importIncreamentConfig == null) {
            this.importIncreamentConfig = new ImportIncreamentConfig();
        }
        this.importIncreamentConfig.setLastValueType(lastValueType);
        return this;
    }

    public BaseImportBuilder setJdbcFetchSize(Integer jdbcFetchSize) {
        this._setJdbcFetchSize(jdbcFetchSize);
        return this;
    }

    public Integer getScheduleBatchSize() {
        return this.scheduleBatchSize;
    }

    public BaseImportBuilder setScheduleBatchSize(Integer scheduleBatchSize) {
        this.scheduleBatchSize = scheduleBatchSize;
        return this;
    }

    public BaseImportBuilder addCallInterceptor(CallInterceptor interceptor) {
        if (this.callInterceptors == null) {
            this.callInterceptors = new ArrayList<CallInterceptor>();
        }
        this.callInterceptors.add(interceptor);
        return this;
    }

    public boolean isPrintTaskLog() {
        return this.printTaskLog;
    }

    public BaseImportBuilder setPrintTaskLog(boolean printTaskLog) {
        this.printTaskLog = printTaskLog;
        return this;
    }

    public String toString() {
        if (this.configString != null) {
            return this.configString;
        }
        try {
            StringBuilder ret = new StringBuilder();
            ret.append(SimpleStringUtil.object2json((Object)this));
            this.configString = ret.toString();
            return this.configString;
        }
        catch (Exception e) {
            this.configString = "";
            return this.configString;
        }
    }

    public void _setShowSql(boolean showSql) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setShowSql(showSql);
    }

    public void _setDbName(String dbName) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbName(dbName);
    }

    public void _setDbDriver(String dbDriver) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbDriver(dbDriver);
    }

    public void _setEnableDBTransaction(boolean enableDBTransaction) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setEnableDBTransaction(enableDBTransaction);
    }

    public void _setDbAdaptor(String dbAdaptor) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbAdaptor(dbAdaptor);
    }

    public void _setDbtype(String dbtype) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbtype(dbtype);
    }

    public void _setDbUrl(String dbUrl) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbUrl(dbUrl);
    }

    public void _setDbUser(String dbUser) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setDbUser(dbUser);
    }

    public void _setValidateSQL(String validateSQL) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setValidateSQL(validateSQL);
    }

    public void _setUsePool(boolean usePool) {
        this.freezen = true;
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfig();
        }
        this.dbConfig.setUsePool(usePool);
    }

    public List<DBConfig> getConfigs() {
        return this.configs;
    }

    public static void addFieldValue(List<FieldMeta> fieldValues, String fieldName, Object value) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setEsFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldValues.add(fieldMeta);
    }

    public static void addFieldValue(List<FieldMeta> fieldValues, String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setEsFieldName(fieldName);
        fieldMeta.setValue(value);
        fieldMeta.setDateFormateMeta(BaseImportBuilder.buildDateFormateMeta(dateFormat, locale, timeZone));
        fieldValues.add(fieldMeta);
    }

    public BaseImportBuilder setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public BaseImportBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public BaseImportBuilder setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public DateFormateMeta buildDateFormateMeta(String dateFormat) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public static DateFormateMeta buildDateFormateMeta(String dateFormat, String locale, String timeZone) {
        return dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone);
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)this.locale, (String)this.timeZone));
        return fieldMeta;
    }

    private static FieldMeta buildIgnoreFieldMeta(String dbColumnName) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setIgnore(true);
        return fieldMeta;
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone));
        return fieldMeta;
    }

    public BaseImportBuilder addFieldMapping(String dbColumnName, String esFieldName) {
        this.fieldMetaMap.put(dbColumnName.toLowerCase(), this.buildFieldMeta(dbColumnName, esFieldName, null));
        return this;
    }

    public BaseImportBuilder addIgnoreFieldMapping(String dbColumnName) {
        BaseImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, dbColumnName);
        return this;
    }

    public static void addIgnoreFieldMapping(Map<String, FieldMeta> fieldMetaMap, String dbColumnName) {
        fieldMetaMap.put(dbColumnName.toLowerCase(), BaseImportBuilder.buildIgnoreFieldMeta(dbColumnName));
    }

    public BaseImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat) {
        this.fieldMetaMap.put(dbColumnName.toLowerCase(), this.buildFieldMeta(dbColumnName, esFieldName, dateFormat));
        return this;
    }

    public BaseImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        this.fieldMetaMap.put(dbColumnName.toLowerCase(), this.buildFieldMeta(dbColumnName, esFieldName, dateFormat, locale, timeZone));
        return this;
    }

    public BaseImportBuilder addFieldValue(String fieldName, Object value) {
        BaseImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        return this;
    }

    public BaseImportBuilder addFieldValue(String fieldName, String dateFormat, Object value) {
        BaseImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.locale, this.timeZone);
        return this;
    }

    public BaseImportBuilder addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        BaseImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        return this;
    }

    public DataRefactor getDataRefactor() {
        return this.dataRefactor;
    }

    public BaseImportBuilder setDataRefactor(DataRefactor dataRefactor) {
        this.dataRefactor = dataRefactor;
        return this;
    }

    public BaseImportBuilder setExternalTimer(boolean externalTimer) {
        this.externalTimer = externalTimer;
        if (this.scheduleConfig == null) {
            this.scheduleConfig = new ScheduleConfig();
        }
        this.scheduleConfig.setExternalTimer(externalTimer);
        return this;
    }

    public boolean isPagine() {
        return this.pagine;
    }

    public BaseImportBuilder setPagine(boolean pagine) {
        this.pagine = pagine;
        return this;
    }

    protected void buildImportConfig(BaseImportConfig baseImportConfig) {
        baseImportConfig.setDateFormat(this.dateFormat);
        baseImportConfig.setLocale(this.locale);
        baseImportConfig.setTimeZone(this.timeZone);
        baseImportConfig.setEsDocAsUpsert(this.esDocAsUpsert);
        baseImportConfig.setEsIdField(this.esIdField);
        baseImportConfig.setEsParentIdField(this.esParentIdField);
        baseImportConfig.setEsParentIdValue(this.esParentIdValue);
        baseImportConfig.setEsRetryOnConflict(this.esRetryOnConflict);
        baseImportConfig.setEsReturnSource(this.esReturnSource);
        baseImportConfig.setEsVersionField(this.esVersionField);
        baseImportConfig.setEsVersionValue(this.esVersionValue);
        baseImportConfig.setEsVersionType(this.esVersionType);
        baseImportConfig.setFetchSize(this.fetchSize);
        baseImportConfig.setRoutingField(this.routingField);
        baseImportConfig.setRoutingValue(this.routingValue);
        baseImportConfig.setUseJavaName(this.useJavaName);
        baseImportConfig.setFieldMetaMap(this.fieldMetaMap);
        baseImportConfig.setFieldValues(this.fieldValues);
        baseImportConfig.setDataRefactor(this.dataRefactor);
        baseImportConfig.setSortLastValue(this.sortLastValue);
        baseImportConfig.setDbConfig(this.dbConfig);
        baseImportConfig.setStatusDbConfig(this.statusDbConfig);
        baseImportConfig.setConfigs(this.configs);
        baseImportConfig.setRefreshOption(this.refreshOption);
        baseImportConfig.setBatchSize(this.batchSize);
        if (this.index != null) {
            ESIndexWrapper esIndexWrapper = new ESIndexWrapper(this.index, this.indexType);
            baseImportConfig.setEsIndexWrapper(esIndexWrapper);
        }
        baseImportConfig.setApplicationPropertiesFile(this.applicationPropertiesFile);
        baseImportConfig.setParallel(this.parallel);
        baseImportConfig.setThreadCount(this.threadCount);
        baseImportConfig.setQueue(this.queue);
        baseImportConfig.setAsyn(this.asyn);
        baseImportConfig.setContinueOnError(this.continueOnError);
        baseImportConfig.setDiscardBulkResponse(this.discardBulkResponse);
        baseImportConfig.setDebugResponse(this.debugResponse);
        baseImportConfig.setScheduleConfig(this.scheduleConfig);
        baseImportConfig.setImportIncreamentConfig(this.importIncreamentConfig);
        if (this.scheduleBatchSize != null) {
            baseImportConfig.setScheduleBatchSize(this.scheduleBatchSize);
        } else {
            baseImportConfig.setScheduleBatchSize(this.batchSize);
        }
        baseImportConfig.setCallInterceptors(this.callInterceptors);
        baseImportConfig.setUseLowcase(this.useLowcase);
        baseImportConfig.setPrintTaskLog(this.printTaskLog);
        baseImportConfig.setEsIdGenerator(this.esIdGenerator);
        if (this.exportResultHandler != null) {
            baseImportConfig.setExportResultHandler(this.buildExportResultHandler(this.exportResultHandler));
        }
        baseImportConfig.setPagine(this.pagine);
    }

    protected abstract WrapedExportResultHandler buildExportResultHandler(ExportResultHandler var1);

    public BaseImportBuilder setIndexType(String indexType) {
        this.indexType = indexType;
        return this;
    }

    public BaseImportBuilder setIndex(String index) {
        this.index = index;
        return this;
    }

    public BaseImportBuilder setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public BaseImportBuilder setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
        return this;
    }

    public boolean isFreezen() {
        return this.freezen;
    }

    public void setFreezen(boolean freezen) {
        this.freezen = freezen;
    }

    public String getRefreshOption() {
        return this.refreshOption;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String getEsIdField() {
        return this.esIdField;
    }

    public String getEsParentIdField() {
        return this.esParentIdField;
    }

    public String getRoutingField() {
        return this.routingField;
    }

    public String getRoutingValue() {
        return this.routingValue;
    }

    public Boolean getEsDocAsUpsert() {
        return this.esDocAsUpsert;
    }

    public Integer getEsRetryOnConflict() {
        return this.esRetryOnConflict;
    }

    public Boolean getEsReturnSource() {
        return this.esReturnSource;
    }

    public String getEsVersionField() {
        return this.esVersionField;
    }

    public String getEsVersionType() {
        return this.esVersionType;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public BaseImportBuilder setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
        return this;
    }

    public BaseImportBuilder setEsVersionType(String esVersionType) {
        this.esVersionType = esVersionType;
        return this;
    }

    public BaseImportBuilder setEsVersionField(String esVersionField) {
        this.esVersionField = esVersionField;
        return this;
    }

    public BaseImportBuilder setEsReturnSource(Boolean esReturnSource) {
        this.esReturnSource = esReturnSource;
        return this;
    }

    public BaseImportBuilder setEsRetryOnConflict(Integer esRetryOnConflict) {
        this.esRetryOnConflict = esRetryOnConflict;
        return this;
    }

    public BaseImportBuilder setEsDocAsUpsert(Boolean esDocAsUpsert) {
        this.esDocAsUpsert = esDocAsUpsert;
        return this;
    }

    public BaseImportBuilder setRoutingValue(String routingValue) {
        this.routingValue = routingValue;
        return this;
    }

    public BaseImportBuilder setRoutingField(String routingField) {
        this.routingField = routingField;
        return this;
    }

    public BaseImportBuilder setEsParentIdField(String esParentIdField) {
        this.esParentIdField = esParentIdField;
        return this;
    }

    public BaseImportBuilder setEsIdField(String esIdField) {
        this.esIdField = esIdField;
        return this;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public BaseImportBuilder setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public abstract DataStream builder();
}

