/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.context;

import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.ColumnData;
import org.frameworkset.elasticsearch.client.DataRefactor;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.client.config.BaseImportConfig;
import org.frameworkset.elasticsearch.client.context.Context;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.db2es.DB2ESImportBuilder;
import org.frameworkset.elasticsearch.client.tran.TranMeta;
import org.frameworkset.elasticsearch.client.tran.TranResultSet;
import org.frameworkset.spi.geoip.IpInfo;

public class ContextImpl
implements Context {
    private List<FieldMeta> fieldValues;
    private Map<String, FieldMeta> fieldMetaMap;
    private Map<String, String> newfieldNames;
    private Map<String, ColumnData> newfieldName2ndColumnDatas;
    private BaseImportConfig esjdbc;
    private TranResultSet jdbcResultSet;
    private BatchContext batchContext;
    private boolean drop;
    private ImportContext importContext;

    public ContextImpl(ImportContext importContext, TranResultSet jdbcResultSet, BatchContext batchContext) {
        this.esjdbc = importContext.getImportConfig();
        this.importContext = importContext;
        this.jdbcResultSet = jdbcResultSet;
        this.batchContext = batchContext;
    }

    @Override
    public TranMeta getMetaData() {
        return this.jdbcResultSet.getMetaData();
    }

    @Override
    public Boolean getEsReturnSource() {
        return this.esjdbc.getEsReturnSource();
    }

    @Override
    public Boolean getEsDocAsUpsert() {
        return this.esjdbc.getEsDocAsUpsert();
    }

    @Override
    public List<FieldMeta> getESJDBCFieldValues() {
        return this.esjdbc.getFieldValues();
    }

    @Override
    public Boolean getUseLowcase() {
        return this.esjdbc.getUseLowcase();
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws Exception {
        return this.jdbcResultSet.getValue(i, colName, sqlType);
    }

    @Override
    public Boolean getUseJavaName() {
        return this.esjdbc.getUseJavaName();
    }

    @Override
    public DateFormat getDateFormat() {
        return this.esjdbc.getFormat();
    }

    @Override
    public void refactorData() throws Exception {
        DataRefactor dataRefactor = this.esjdbc.getDataRefactor();
        if (dataRefactor != null) {
            dataRefactor.refactor(this);
        }
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public List<FieldMeta> getFieldValues() {
        return this.fieldValues;
    }

    @Override
    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    @Override
    public Context addFieldValue(String fieldName, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
        }
        DB2ESImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
        }
        DB2ESImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.esjdbc.getLocale(), this.esjdbc.getTimeZone());
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
        }
        DB2ESImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        return this;
    }

    @Override
    public Context addIgnoreFieldMapping(String dbColumnName) {
        if (this.fieldMetaMap == null) {
            this.fieldMetaMap = new HashMap<String, FieldMeta>();
        }
        DB2ESImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, dbColumnName);
        return this;
    }

    @Override
    public String getDBName() {
        return this.esjdbc.getDbConfig().getDbName();
    }

    @Override
    public long getLongValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.longValue((Object)value, (Long)0L);
    }

    @Override
    public double getDoubleValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.doubleValue((Object)value, (Double)0.0);
    }

    @Override
    public float getFloatValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.floatValue((Object)value, (Float)Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getIntegerValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.intValue((Object)value, (Integer)0);
    }

    @Override
    public Date getDateValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    @Override
    public Date getDateValue(String fieldName, DateFormat dateFormat) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String) {
            return dateFormat.parse((String)value);
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    @Override
    public Object getValue(String fieldName) throws Exception {
        return this.jdbcResultSet.getValue(fieldName);
    }

    @Override
    public FieldMeta getMappingName(String colName) {
        FieldMeta fieldMeta;
        if (this.fieldMetaMap != null && (fieldMeta = this.fieldMetaMap.get(colName.toLowerCase())) != null) {
            return fieldMeta;
        }
        return this.esjdbc.getMappingName(colName);
    }

    @Override
    public Object getEsId() throws Exception {
        return this.esjdbc.getEsIdGenerator().genId(this);
    }

    @Override
    public String getEsIdField() {
        return this.esjdbc.getEsIdField();
    }

    @Override
    public boolean isDrop() {
        return this.drop;
    }

    @Override
    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    @Override
    public IpInfo getIpInfo(String fieldName) throws Exception {
        Object _ip = this.jdbcResultSet.getValue(fieldName);
        if (_ip == null) {
            return null;
        }
        ContextImpl contextImpl = this;
        if (contextImpl.esjdbc.getGeoIPUtil() != null) {
            ContextImpl contextImpl2 = this;
            return contextImpl2.esjdbc.getGeoIPUtil().getAddressMapResult(String.valueOf(_ip));
        }
        return null;
    }

    @Override
    public IpInfo getIpInfoByIp(String ip) {
        ContextImpl contextImpl = this;
        if (contextImpl.esjdbc.getGeoIPUtil() != null) {
            ContextImpl contextImpl2 = this;
            return contextImpl2.esjdbc.getGeoIPUtil().getAddressMapResult(ip);
        }
        return null;
    }

    @Override
    public void newName2ndData(String fieldName, String newFieldName, Object newFieldValue) throws Exception {
        this.addFieldValue(newFieldName, newFieldValue);
        if (!fieldName.equals(newFieldName)) {
            this.addIgnoreFieldMapping(fieldName);
        }
    }

    @Override
    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    @Override
    public Object getParentId() throws Exception {
        if (this.esjdbc.getEsParentIdField() != null) {
            return this.jdbcResultSet.getValue(this.esjdbc.getEsParentIdField());
        }
        return this.esjdbc.getEsParentIdValue();
    }

    @Override
    public Object getRouting() throws Exception {
        Object routing = this.jdbcResultSet.getValue(this.esjdbc.getRoutingField());
        if (routing == null) {
            routing = this.esjdbc.getRoutingValue();
        }
        return routing;
    }

    @Override
    public Object getEsRetryOnConflict() {
        return this.esjdbc.getEsRetryOnConflict();
    }

    @Override
    public ESIndexWrapper getESIndexWrapper() {
        return this.esjdbc.getEsIndexWrapper();
    }

    @Override
    public Object getVersion() throws Exception {
        Object version = this.esjdbc.getEsVersionField() != null ? this.jdbcResultSet.getValue(this.esjdbc.getEsVersionField()) : this.esjdbc.getEsVersionValue();
        return version;
    }

    @Override
    public Object getEsVersionType() {
        return this.esjdbc.getEsVersionType();
    }
}

