/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.db2es;

import org.frameworkset.elasticsearch.client.ExportResultHandler;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.client.WrapedExportResultHandler;
import org.frameworkset.elasticsearch.client.task.TaskCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2ESExportResultHandler
implements WrapedExportResultHandler<String, String> {
    private static Logger logger = LoggerFactory.getLogger(DB2ESExportResultHandler.class);
    private ExportResultHandler exportResultHandler;

    public DB2ESExportResultHandler(ExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
    }

    @Override
    public void success(TaskCommand<String, String> taskCommand, String result) {
        this.exportResultHandler.success(taskCommand, result);
    }

    @Override
    public void error(TaskCommand<String, String> taskCommand, String result) {
        this.exportResultHandler.error(taskCommand, result);
    }

    @Override
    public void exception(TaskCommand<String, String> taskCommand, Exception exception) {
        this.exportResultHandler.exception(taskCommand, exception);
    }

    @Override
    public int getMaxRetry() {
        return this.exportResultHandler.getMaxRetry();
    }

    @Override
    public void handleResult(TaskCommand<String, String> taskCommand, String result) {
        if (!ResultUtil.bulkResponseError((String)result)) {
            this.success(taskCommand, result);
        } else {
            this.error(taskCommand, result);
        }
    }

    @Override
    public void handleException(TaskCommand<String, String> taskCommand, Exception exception) {
        try {
            this.exception(taskCommand, exception);
        }
        catch (Exception e) {
            logger.warn("Handle Task Exception failed:", (Throwable)e);
        }
    }
}

