/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.db2es;

import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.util.SimpleStringUtil;
import java.sql.ResultSet;
import org.frameworkset.elasticsearch.client.DataStream;
import org.frameworkset.elasticsearch.client.ExportResultHandler;
import org.frameworkset.elasticsearch.client.WrapedExportResultHandler;
import org.frameworkset.elasticsearch.client.config.BaseImportBuilder;
import org.frameworkset.elasticsearch.client.db2es.DB2ESDataStreamImpl;
import org.frameworkset.elasticsearch.client.db2es.DB2ESExportResultHandler;
import org.frameworkset.elasticsearch.client.db2es.DB2ESImportConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2ESImportBuilder
extends BaseImportBuilder {
    private static Logger logger = LoggerFactory.getLogger(DB2ESImportBuilder.class);
    protected String sqlFilepath;
    protected String sql;
    protected String sqlName;
    private ResultSet resultSet;
    private StatementInfo statementInfo;

    protected DB2ESImportBuilder() {
    }

    public DB2ESImportBuilder setShowSql(boolean showSql) {
        this._setShowSql(showSql);
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public static DB2ESImportBuilder newInstance() {
        return new DB2ESImportBuilder();
    }

    public DB2ESImportBuilder setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        return this;
    }

    public DB2ESImportBuilder setStatementInfo(StatementInfo statementInfo) {
        this.statementInfo = statementInfo;
        return this;
    }

    public DB2ESImportBuilder setSql(String sql) {
        this.sql = sql;
        return this;
    }

    @Override
    public DataStream builder() {
        super.builderConfig();
        try {
            logger.info("DB2ES Import Configs:");
            logger.info(this.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DB2ESImportConfig importConfig = new DB2ESImportConfig();
        super.buildImportConfig(importConfig);
        importConfig.setSqlFilepath(this.sqlFilepath);
        importConfig.setSqlName(this.sqlName);
        if (SimpleStringUtil.isNotEmpty((String)this.sql)) {
            importConfig.setSql(this.sql);
        }
        DB2ESDataStreamImpl dataStream = new DB2ESDataStreamImpl();
        dataStream.setImportConfig(importConfig);
        dataStream.setConfigString(this.toString());
        dataStream.init();
        return dataStream;
    }

    public DB2ESImportBuilder setSqlFilepath(String sqlFilepath) {
        this.sqlFilepath = sqlFilepath;
        return this;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public DB2ESImportBuilder setSqlName(String sqlName) {
        this.sqlName = sqlName;
        return this;
    }

    @Override
    protected WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        DB2ESExportResultHandler db2ESExportResultHandler = new DB2ESExportResultHandler(exportResultHandler);
        return db2ESExportResultHandler;
    }
}

