/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.db2es;

import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.orm.adapter.DB;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.db2es.JDBCTranMetaData;
import org.frameworkset.elasticsearch.client.tran.TranMeta;
import org.frameworkset.elasticsearch.client.tran.TranResultSet;

public class JDBCResultSet
implements TranResultSet {
    protected ResultSet resultSet;
    protected TranMeta metaData;
    protected DB dbadapter;

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public DB getDbadapter() {
        return this.dbadapter;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public TranMeta getMetaData() {
        return this.metaData;
    }

    public void setMetaData(PoolManResultSetMetaData metaData) {
        this.metaData = new JDBCTranMetaData(metaData);
    }

    public boolean isOracleTimestamp(int sqlType) {
        return this.dbadapter.isOracleTimestamp(sqlType);
    }

    public void setDbadapter(DB dbadapter) {
        this.dbadapter = dbadapter;
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws ESDataImportException {
        try {
            if (!this.isOracleTimestamp(sqlType)) {
                return this.resultSet.getObject(i + 1);
            }
            return this.resultSet.getTimestamp(i + 1);
        }
        catch (Exception ex) {
            throw new ESDataImportException("getValue(  " + i + ", " + colName + "," + sqlType + ")", ex);
        }
    }

    @Override
    public Object getValue(String colName) throws ESDataImportException {
        if (colName == null) {
            return null;
        }
        try {
            Object value = this.resultSet.getObject(colName);
            return value;
        }
        catch (Exception ex) {
            throw new ESDataImportException("getValue(" + colName + ")", ex);
        }
    }

    @Override
    public Object getValue(String colName, int sqlType) throws ESDataImportException {
        if (colName == null) {
            return null;
        }
        try {
            if (!this.isOracleTimestamp(sqlType)) {
                return this.resultSet.getObject(colName);
            }
            return this.resultSet.getTimestamp(colName);
        }
        catch (Exception ex) {
            throw new ESDataImportException("getValue(  " + colName + "," + sqlType + ")", ex);
        }
    }

    @Override
    public Date getDateTimeValue(String colName) throws ESDataImportException {
        if (colName == null) {
            return null;
        }
        try {
            Timestamp value = this.resultSet.getTimestamp(colName);
            return value;
        }
        catch (Exception e) {
            try {
                java.sql.Date value = this.resultSet.getDate(colName);
                return value;
            }
            catch (Exception ex) {
                throw new ESDataImportException("getValue(" + colName + ")", ex);
            }
        }
    }

    @Override
    public boolean next() throws ESDataImportException {
        try {
            return this.resultSet.next();
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }
}

