/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.db2es;

import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.metrics.ImportCount;
import org.frameworkset.elasticsearch.client.task.BaseTaskCommand;
import org.frameworkset.elasticsearch.client.task.TaskCommand;
import org.frameworkset.elasticsearch.client.task.TaskFailedException;
import org.frameworkset.elasticsearch.handler.ESVoidResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCommandImpl
extends BaseTaskCommand<String, String> {
    private String refreshOption;
    private ClientInterface clientInterface;
    private String datas;
    private int tryCount;
    private static Logger logger = LoggerFactory.getLogger(TaskCommand.class);

    public TaskCommandImpl(ImportCount importCount, ImportContext importContext, long dataSize, int taskNo, String jobNo) {
        super(importCount, importContext, dataSize, taskNo, jobNo);
    }

    public String getRefreshOption() {
        return this.refreshOption;
    }

    public ClientInterface getClientInterface() {
        return this.clientInterface;
    }

    @Override
    public String getDatas() {
        return this.datas;
    }

    public void setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
    }

    public void setClientInterface(ClientInterface clientInterface) {
        this.clientInterface = clientInterface;
    }

    @Override
    public void setDatas(String datas) {
        this.datas = datas;
    }

    @Override
    public String execute() {
        String data = null;
        if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
            throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
        }
        ++this.tryCount;
        if (this.importContext.isDebugResponse()) {
            if (this.refreshOption == null) {
                data = this.clientInterface.executeHttp("_bulk", this.datas, "post");
                if (logger.isInfoEnabled()) {
                    logger.info(data);
                }
            } else {
                data = this.clientInterface.executeHttp("_bulk?" + this.refreshOption, this.datas, "post");
                if (logger.isInfoEnabled()) {
                    logger.info(data);
                }
            }
        } else {
            if (this.importContext.isDiscardBulkResponse() && this.importContext.getExportResultHandler() == null) {
                ESVoidResponseHandler esVoidResponseHandler = new ESVoidResponseHandler();
                if (this.refreshOption == null) {
                    this.clientInterface.executeHttp("_bulk", this.datas, "post", (ResponseHandler)esVoidResponseHandler);
                } else {
                    this.clientInterface.executeHttp("_bulk?" + this.refreshOption, this.datas, "post", (ResponseHandler)esVoidResponseHandler);
                }
                if (esVoidResponseHandler.getElasticSearchException() != null) {
                    throw esVoidResponseHandler.getElasticSearchException();
                }
                return null;
            }
            data = this.refreshOption == null ? this.clientInterface.executeHttp("_bulk", this.datas, "post") : this.clientInterface.executeHttp("_bulk?" + this.refreshOption, this.datas, "post");
        }
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

