/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.estodb;

import com.frameworkset.util.VariableHandler;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.TranErrorWrapper;
import org.frameworkset.elasticsearch.client.context.Context;
import org.frameworkset.elasticsearch.client.context.ContextImpl;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.estodb.ES2DBContext;
import org.frameworkset.elasticsearch.client.estodb.ES2DBImportContext;
import org.frameworkset.elasticsearch.client.estodb.ESExporterScrollHandler;
import org.frameworkset.elasticsearch.client.estodb.ESTranResultSet;
import org.frameworkset.elasticsearch.client.estodb.TaskCommandImpl;
import org.frameworkset.elasticsearch.client.metrics.ImportCount;
import org.frameworkset.elasticsearch.client.metrics.ParallImportCount;
import org.frameworkset.elasticsearch.client.metrics.SerialImportCount;
import org.frameworkset.elasticsearch.client.schedule.Status;
import org.frameworkset.elasticsearch.client.task.TaskCall;
import org.frameworkset.elasticsearch.client.tran.BaseDataTran;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ES2DBDataTran
extends BaseDataTran {
    private static Logger logger = LoggerFactory.getLogger(ES2DBDataTran.class);
    private ES2DBContext es2DBContext;
    private ESTranResultSet esTranResultSet;

    @Override
    public void logTaskStart(Logger logger) {
        logger.info("import data to db[" + this.importContext.getDbConfig().getDbUrl() + "] dbuser[" + this.importContext.getDbConfig().getDbUser() + " sql[" + this.es2DBContext.getSqlInfo().getOriginSQL() + "] start.");
    }

    @Override
    protected void init() {
        this.es2DBContext = (ES2DBContext)((Object)this.importContext);
        this.esTranResultSet = (ESTranResultSet)this.jdbcResultSet;
    }

    public ES2DBDataTran(ESTranResultSet jdbcResultSet, ImportContext importContext) {
        super(jdbcResultSet, importContext);
    }

    public ES2DBDataTran(ESTranResultSet jdbcResultSet, ImportContext importContext, CountDownLatch countDownLatch) {
        super(jdbcResultSet, importContext, countDownLatch);
    }

    public void appendData(ESDatas datas, ESExporterScrollHandler exporterScrollHandler) {
        this.esTranResultSet.appendData(datas, exporterScrollHandler);
    }

    @Override
    public void stop() {
        this.esTranResultSet.stop();
        super.stop();
    }

    @Override
    public String serialExecute() {
        Object lastValue = null;
        Throwable exception = null;
        long start = System.currentTimeMillis();
        Status currentStatus = this.importContext.getCurrentStatus();
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        SerialImportCount importCount = new SerialImportCount();
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        try {
            ES2DBImportContext.SQLInfo sqlinfo = this.es2DBContext.getSqlInfo();
            Object temp = null;
            Object param = null;
            ArrayList<List<Param>> records = new ArrayList<List<Param>>();
            while (this.jdbcResultSet.next()) {
                try {
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    ContextImpl context = new ContextImpl(this.importContext, this.jdbcResultSet, null);
                    context.refactorData();
                    if (context.isDrop()) {
                        ++ignoreTotalCount;
                        continue;
                    }
                    List<Param> record = this.buildRecord(context, sqlinfo.getVars());
                    records.add(record);
                    ++totalCount;
                }
                catch (Exception e) {
                    throw new ElasticSearchException((Throwable)e);
                }
            }
            TaskCommandImpl taskCommand = new TaskCommandImpl(sqlinfo.getSql(), importCount, this.importContext, records, 1, importCount.getJobNo());
            TaskCall.call(taskCommand);
            this.importContext.flushLastValue(lastValue);
            if (this.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                logger.info("All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition((Exception)exception, this.importContext)) {
                this.stop();
            }
            if (this.importContext.isCurrentStoped()) {
                this.stop();
            }
            importCount.setJobEndTime(new Date());
        }
        return null;
    }

    private List<Param> buildRecord(Context context, List<VariableHandler.Variable> vars) {
        Object temp = null;
        Param param = null;
        ArrayList<Param> record = new ArrayList<Param>();
        HashMap<String, Object> addedFields = new HashMap<String, Object>();
        List<FieldMeta> fieldValueMetas = context.getFieldValues();
        this.appendFieldValues(record, vars, fieldValueMetas, addedFields);
        fieldValueMetas = context.getESJDBCFieldValues();
        this.appendFieldValues(record, vars, fieldValueMetas, addedFields);
        for (int i = 0; i < vars.size(); ++i) {
            VariableHandler.Variable var = vars.get(i);
            if (addedFields.get(var.getVariableName()) != null) continue;
            temp = this.jdbcResultSet.getValue(var.getVariableName());
            if (temp == null) {
                logger.warn("\u672a\u6307\u5b9a\u7ed1\u5b9a\u53d8\u91cf\u7684\u503c\uff1a{}", (Object)var.getVariableName());
            }
            param = new Param();
            param.setVariable(var);
            param.setIndex(var.getPosition() + 1);
            param.setValue(temp);
            param.setName(var.getVariableName());
            record.add(param);
        }
        return record;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute() {
        TranErrorWrapper tranErrorWrapper;
        Object lastValue;
        Throwable exception;
        ParallImportCount totalCount;
        ArrayList<Future> tasks;
        ExecutorService service;
        block13: {
            int count = 0;
            service = this.importContext.buildThreadPool();
            tasks = new ArrayList<Future>();
            int taskNo = 0;
            totalCount = new ParallImportCount();
            exception = null;
            Status currentStatus = this.importContext.getCurrentStatus();
            Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
            lastValue = null;
            tranErrorWrapper = new TranErrorWrapper(this.importContext);
            int batchsize = this.importContext.getStoreBatchSize();
            try {
                ES2DBImportContext.SQLInfo sqlinfo = this.es2DBContext.getSqlInfo();
                Object temp = null;
                Object param = null;
                ArrayList<List<Param>> records = new ArrayList<List<Param>>();
                while (this.jdbcResultSet.next()) {
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    ContextImpl context = new ContextImpl(this.importContext, this.jdbcResultSet, null);
                    context.refactorData();
                    if (context.isDrop()) {
                        ((ImportCount)totalCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    List<Param> record = this.buildRecord(context, sqlinfo.getVars());
                    records.add(record);
                    if (++count != batchsize) continue;
                    count = 0;
                    TaskCommandImpl taskCommand = new TaskCommandImpl(sqlinfo.getSql(), totalCount, this.importContext, records, ++taskNo, totalCount.getJobNo());
                    records = new ArrayList();
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                }
                if (count > 0) {
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    TaskCommandImpl taskCommand = new TaskCommandImpl(sqlinfo.getSql(), totalCount, this.importContext, records, ++taskNo, totalCount.getJobNo());
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    if (this.isPrintTaskLog()) {
                        logger.info("submit tasks:" + taskNo);
                    }
                    break block13;
                }
                if (this.isPrintTaskLog()) {
                    logger.info("submit tasks:" + taskNo);
                }
            }
            catch (SQLException e) {
                try {
                    exception = e;
                    throw new ElasticSearchException((Throwable)e);
                    catch (ElasticSearchException e2) {
                        exception = e2;
                        throw e2;
                    }
                    catch (Exception e3) {
                        exception = e3;
                        throw new ElasticSearchException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper);
                    totalCount.setJobEndTime(new Date());
                    throw throwable;
                }
            }
        }
        this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper);
        totalCount.setJobEndTime(new Date());
        return null;
    }

    @Override
    public String batchExecute() {
        int count = 0;
        String ret = null;
        int taskNo = 0;
        Throwable exception = null;
        Status currentStatus = this.importContext.getCurrentStatus();
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        TranErrorWrapper tranErrorWrapper = new TranErrorWrapper(this.importContext);
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        int batchsize = this.importContext.getStoreBatchSize();
        String refreshOption = this.importContext.getRefreshOption();
        try {
            istart = start;
            ES2DBImportContext.SQLInfo sqlinfo = this.es2DBContext.getSqlInfo();
            ArrayList<List<Param>> records = new ArrayList<List<Param>>();
            while (this.jdbcResultSet.next()) {
                if (!tranErrorWrapper.assertCondition()) {
                    tranErrorWrapper.throwError();
                }
                lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                ContextImpl context = new ContextImpl(this.importContext, this.jdbcResultSet, null);
                context.refactorData();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                List<Param> record = this.buildRecord(context, sqlinfo.getVars());
                records.add(record);
                if (++count != batchsize) continue;
                count = 0;
                TaskCommandImpl taskCommand = new TaskCommandImpl(sqlinfo.getSql(), importCount, this.importContext, records, ++taskNo, importCount.getJobNo());
                records = new ArrayList();
                ret = TaskCall.call(taskCommand);
                this.importContext.flushLastValue(lastValue);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    logger.info("Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + batchsize + " records.");
                    istart = end;
                }
                totalCount += (long)batchsize;
            }
            if (count > 0) {
                if (!tranErrorWrapper.assertCondition()) {
                    tranErrorWrapper.throwError();
                }
                TaskCommandImpl taskCommand = new TaskCommandImpl(sqlinfo.getSql(), importCount, this.importContext, records, ++taskNo, importCount.getJobNo());
                ret = TaskCall.call(taskCommand);
                this.importContext.flushLastValue(lastValue);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    logger.info("Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records.");
                }
                totalCount += (long)count;
            }
            if (this.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                logger.info("Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!tranErrorWrapper.assertCondition((Exception)exception)) {
                this.stop();
            }
            importCount.setJobEndTime(new Date());
        }
        return ret;
    }

    private void appendFieldValues(List<Param> record, List<VariableHandler.Variable> vars, List<FieldMeta> fieldValueMetas, Map<String, Object> addedFields) {
        if (fieldValueMetas == null || fieldValueMetas.size() == 0) {
            return;
        }
        boolean i = false;
        Param param = null;
        block0: for (VariableHandler.Variable variable : vars) {
            if (addedFields.containsKey(variable.getVariableName())) continue;
            for (FieldMeta fieldMeta : fieldValueMetas) {
                if (!variable.getVariableName().equals(fieldMeta.getEsFieldName())) continue;
                param = new Param();
                param.setVariable(variable);
                param.setIndex(variable.getPosition() + 1);
                param.setValue(fieldMeta.getValue());
                param.setName(variable.getVariableName());
                record.add(param);
                addedFields.put(variable.getVariableName(), dummy);
                continue block0;
            }
        }
    }

    public static class Param {
        private int index;
        private Object value;
        private String name;
        private VariableHandler.Variable variable;

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{name:").append(this.name).append(",value:").append(this.value).append(",postion:").append(this.index).append("}");
            return builder.toString();
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public VariableHandler.Variable getVariable() {
            return this.variable;
        }

        public void setVariable(VariableHandler.Variable variable) {
            this.variable = variable;
        }
    }
}

