/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.estodb;

import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.util.VariableHandler;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.estodb.ES2DBContext;
import org.frameworkset.elasticsearch.client.estodb.ES2DBDataTran;
import org.frameworkset.elasticsearch.client.estodb.ES2DBImportContext;
import org.frameworkset.elasticsearch.client.estodb.ESDirectExporterScrollHandler;
import org.frameworkset.elasticsearch.client.estodb.ESExporterScrollHandler;
import org.frameworkset.elasticsearch.client.estodb.ESTranResultSet;
import org.frameworkset.elasticsearch.client.tran.DataTranPlugin;
import org.frameworkset.elasticsearch.client.tran.SQLBaseDataTranPlugin;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.persitent.util.SQLInfo;

public class ES2DBDataTranPlugin
extends SQLBaseDataTranPlugin
implements DataTranPlugin {
    private ES2DBContext es2DBContext;

    @Override
    protected void init(ImportContext importContext) {
        super.init(importContext);
        this.es2DBContext = (ES2DBContext)((Object)importContext);
    }

    private void initSQLInfo() throws ESDataImportException {
        ES2DBImportContext.SQLInfo sqlInfo = new ES2DBImportContext.SQLInfo();
        ConfigSQLExecutor configSQLExecutor = new ConfigSQLExecutor(this.es2DBContext.getSqlFilepath());
        try {
            SQLInfo sqlinfo = configSQLExecutor.getSqlInfo(this.importContext.getDbConfig().getDbName(), this.es2DBContext.getSqlName());
            sqlInfo.setOriginSQL(sqlinfo.getSql());
            String sql = this.parserSQL(sqlinfo);
            VariableHandler.SQLStruction sqlstruction = sqlinfo.getSqlutil().getSQLStruction(sqlinfo, sql);
            sql = sqlstruction.getSql();
            sqlInfo.setSql(sql);
            List vars = sqlstruction.getVariables();
            sqlInfo.setVars(vars);
            this.es2DBContext.setSqlInfo(sqlInfo);
        }
        catch (SQLException e) {
            throw new ESDataImportException("Init SQLInfo failed", e);
        }
    }

    public ES2DBDataTranPlugin(ImportContext importContext) {
        super(importContext);
    }

    @Override
    public void beforeInit() {
        this.initES(this.importContext.getApplicationPropertiesFile());
        this.initDS(this.importContext.getDbConfig());
        this.initOtherDSes(this.importContext.getConfigs());
    }

    @Override
    public void afterInit() {
        this.initSQLInfo();
        this.initDSLInfo();
    }

    public void initDSLInfo() {
        if (this.isIncreamentImport() && this.es2DBContext.getDslFile() != null && !this.es2DBContext.getDslFile().equals("")) {
            try {
                ClientInterface clientInterface = ElasticSearchHelper.getConfigRestClientUtil((String)this.es2DBContext.getDslFile());
                ESInfo esInfo = clientInterface.getESInfo(this.es2DBContext.getDslName());
                this.importContext.setStatusTableId(esInfo.getTemplate().hashCode());
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        }
    }

    private void commonImportData(ESExporterScrollHandler<Map> esExporterScrollHandler) throws Exception {
        Map<String, Integer> params = this.es2DBContext.getParams() != null ? this.es2DBContext.getParams() : new HashMap();
        params.put("size", this.importContext.getFetchSize());
        if (this.es2DBContext.isSliceQuery()) {
            params.put("sliceMax", this.es2DBContext.getSliceSize());
        }
        this.exportESData(esExporterScrollHandler, params);
    }

    private void exportESData(ESExporterScrollHandler<Map> esExporterScrollHandler, Map params) {
        ClientInterface clientUtil = ElasticSearchHelper.getConfigRestClientUtil((String)this.es2DBContext.getDslFile());
        ESDatas response = null;
        response = !this.es2DBContext.isSliceQuery() ? (this.importContext.isParallel() && esExporterScrollHandler instanceof ESDirectExporterScrollHandler ? clientUtil.scrollParallel(this.es2DBContext.getQueryUrl(), this.es2DBContext.getDslName(), this.es2DBContext.getScrollLiveTime(), params, Map.class, esExporterScrollHandler) : clientUtil.scroll(this.es2DBContext.getQueryUrl(), this.es2DBContext.getDslName(), this.es2DBContext.getScrollLiveTime(), params, Map.class, esExporterScrollHandler)) : clientUtil.scrollSliceParallel(this.es2DBContext.getQueryUrl(), this.es2DBContext.getDslName(), params, this.es2DBContext.getScrollLiveTime(), Map.class, esExporterScrollHandler);
        if (this.logger.isInfoEnabled()) {
            if (response != null) {
                this.logger.info("Export compoleted and export total {} records.", (Object)response.getTotalSize());
            } else {
                this.logger.info("Export compoleted and export no records or failed.");
            }
        }
    }

    private void increamentImportData(ESExporterScrollHandler<Map> esExporterScrollHandler) throws Exception {
        Map<String, Integer> params = this.es2DBContext.getParams() != null ? this.es2DBContext.getParams() : new HashMap();
        params.put("size", this.importContext.getFetchSize());
        if (this.es2DBContext.isSliceQuery()) {
            params.put("sliceMax", this.es2DBContext.getSliceSize());
        }
        this.putLastParamValue(params);
        this.exportESData(esExporterScrollHandler, params);
    }

    @Override
    public void doImportData() throws ESDataImportException {
        ESTranResultSet jdbcResultSet = new ESTranResultSet(this.importContext);
        if (this.es2DBContext.getBatchHandler() != null) {
            ES2DBDataTran es2DBDataTran = new ES2DBDataTran(jdbcResultSet, this.importContext);
            ESDirectExporterScrollHandler<Map> esDirectExporterScrollHandler = new ESDirectExporterScrollHandler<Map>(this.importContext, this.executor, es2DBDataTran);
            try {
                if (!this.isIncreamentImport()) {
                    this.commonImportData(esDirectExporterScrollHandler);
                }
                this.increamentImportData(esDirectExporterScrollHandler);
            }
            catch (ESDataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            final ES2DBDataTran es2DBDataTran = new ES2DBDataTran(jdbcResultSet, this.importContext, countDownLatch);
            ESExporterScrollHandler<Map> esExporterScrollHandler = new ESExporterScrollHandler<Map>(this.importContext, this.executor, es2DBDataTran);
            try {
                Thread tranThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        es2DBDataTran.tran();
                    }
                });
                tranThread.start();
                if (!this.isIncreamentImport()) {
                    this.commonImportData(esExporterScrollHandler);
                } else {
                    this.increamentImportData(esExporterScrollHandler);
                }
            }
            catch (ESDataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
            finally {
                block19: {
                    jdbcResultSet.reachEend();
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException e) {
                        if (!this.logger.isErrorEnabled()) break block19;
                        this.logger.error("", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public String getLastValueVarName() {
        return this.importContext.getLastValueClumnName();
    }
}

