/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.estodb;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.util.SimpleStringUtil;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.elasticsearch.client.DataStream;
import org.frameworkset.elasticsearch.client.ExportResultHandler;
import org.frameworkset.elasticsearch.client.WrapedExportResultHandler;
import org.frameworkset.elasticsearch.client.config.BaseImportBuilder;
import org.frameworkset.elasticsearch.client.estodb.ES2DBDataStreamImpl;
import org.frameworkset.elasticsearch.client.estodb.ES2DBExportResultHandler;
import org.frameworkset.elasticsearch.client.estodb.ES2DBImportConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ES2DBExportBuilder
extends BaseImportBuilder {
    private static Logger logger = LoggerFactory.getLogger(ES2DBExportBuilder.class);
    private String scrollLiveTime = "100m";
    private BatchHandler<Map> batchHandler;
    private Map params;
    private String queryUrl;
    private String dsl2ndSqlFile;
    private String dslName;
    private boolean sliceQuery;
    private int sliceSize;
    private String sqlName;
    private String sql;

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(SimpleStringUtil.object2json((Object)this));
        return ret.toString();
    }

    @Override
    protected WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        return new ES2DBExportResultHandler(exportResultHandler);
    }

    @Override
    public DataStream builder() {
        super.builderConfig();
        try {
            logger.info("ES2DB Import Configs:");
            logger.info(this.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ES2DBImportConfig es2DBImportConfig = new ES2DBImportConfig();
        super.buildImportConfig(es2DBImportConfig);
        es2DBImportConfig.setDsl2ndSqlFile(this.dsl2ndSqlFile);
        es2DBImportConfig.setSqlName(this.sqlName);
        es2DBImportConfig.setSql(this.sql);
        es2DBImportConfig.setQueryUrl(this.queryUrl);
        es2DBImportConfig.setScrollLiveTime(this.scrollLiveTime);
        es2DBImportConfig.setBatchHandler(this.batchHandler);
        es2DBImportConfig.setDslName(this.dslName);
        es2DBImportConfig.setSliceQuery(this.sliceQuery);
        es2DBImportConfig.setSliceSize(this.sliceSize);
        es2DBImportConfig.setParams(this.params);
        ES2DBDataStreamImpl dataStream = new ES2DBDataStreamImpl();
        dataStream.setEs2DBImportConfig(es2DBImportConfig);
        return dataStream;
    }

    public String getSql() {
        return this.sql;
    }

    public ES2DBExportBuilder setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public ES2DBExportBuilder setSqlName(String sqlName) {
        this.sqlName = sqlName;
        return this;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public ES2DBExportBuilder setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
        return this;
    }

    public BatchHandler<Map> getBatchHandler() {
        return this.batchHandler;
    }

    public ES2DBExportBuilder setBatchHandler(BatchHandler<Map> batchHandler) {
        this.batchHandler = batchHandler;
        return this;
    }

    public String getDsl2ndSqlFile() {
        return this.dsl2ndSqlFile;
    }

    public ES2DBExportBuilder setDsl2ndSqlFile(String dsl2ndSqlFile) {
        this.dsl2ndSqlFile = dsl2ndSqlFile;
        return this;
    }

    public String getDslName() {
        return this.dslName;
    }

    public ES2DBExportBuilder setDslName(String dslName) {
        this.dslName = dslName;
        return this;
    }

    public String getScrollLiveTime() {
        return this.scrollLiveTime;
    }

    public ES2DBExportBuilder setScrollLiveTime(String scrollLiveTime) {
        this.scrollLiveTime = scrollLiveTime;
        return this;
    }

    public boolean isSliceQuery() {
        return this.sliceQuery;
    }

    public ES2DBExportBuilder setSliceQuery(boolean sliceQuery) {
        this.sliceQuery = sliceQuery;
        return this;
    }

    public int getSliceSize() {
        return this.sliceSize;
    }

    public ES2DBExportBuilder setSliceSize(int sliceSize) {
        this.sliceSize = sliceSize;
        return this;
    }

    public ES2DBExportBuilder addParam(String key, Object value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        this.params.put(key, value);
        return this;
    }
}

