/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.estodb;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.util.VariableHandler;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.config.BaseImportConfig;
import org.frameworkset.elasticsearch.client.context.BaseImportContext;
import org.frameworkset.elasticsearch.client.estodb.ES2DBContext;
import org.frameworkset.elasticsearch.client.estodb.ES2DBDataTranPlugin;
import org.frameworkset.elasticsearch.client.estodb.ES2DBImportConfig;
import org.frameworkset.elasticsearch.client.tran.DataTranPlugin;

public class ES2DBImportContext
extends BaseImportContext
implements ES2DBContext {
    private ES2DBImportConfig es2DBImportConfig;
    private SQLInfo sqlInfo;

    @Override
    public SQLInfo getSqlInfo() {
        return this.sqlInfo;
    }

    @Override
    public void setSqlInfo(SQLInfo sqlInfo) {
        this.sqlInfo = sqlInfo;
    }

    @Override
    protected DataTranPlugin buildDataTranPlugin() {
        return new ES2DBDataTranPlugin(this);
    }

    @Override
    protected void init(BaseImportConfig baseImportConfig) {
        this.es2DBImportConfig = (ES2DBImportConfig)baseImportConfig;
    }

    public ES2DBImportContext() {
        this(new ES2DBImportConfig());
    }

    public ES2DBImportContext(ES2DBImportConfig baseImportConfig) {
        super(baseImportConfig);
    }

    @Override
    public String getSql() {
        return this.es2DBImportConfig.getSql();
    }

    @Override
    public String getSqlFilepath() {
        return this.es2DBImportConfig.getDsl2ndSqlFile();
    }

    @Override
    public String getSqlName() {
        return this.es2DBImportConfig.getSqlName();
    }

    @Override
    public void setSql(String sql) {
        this.es2DBImportConfig.setSql(sql);
    }

    @Override
    public Map getParams() {
        return this.es2DBImportConfig.getParams();
    }

    @Override
    public boolean isSliceQuery() {
        return this.es2DBImportConfig.isSliceQuery();
    }

    @Override
    public int getSliceSize() {
        return this.es2DBImportConfig.getSliceSize();
    }

    @Override
    public String getQueryUrl() {
        return this.es2DBImportConfig.getQueryUrl();
    }

    @Override
    public String getDslName() {
        return this.es2DBImportConfig.getDslName();
    }

    @Override
    public String getScrollLiveTime() {
        return this.es2DBImportConfig.getScrollLiveTime();
    }

    @Override
    public String getDslFile() {
        return this.es2DBImportConfig.getDsl2ndSqlFile();
    }

    public BatchHandler<Map> getBatchHandler() {
        return this.es2DBImportConfig.getBatchHandler();
    }

    public static class SQLInfo {
        private String originSQL;
        private String sql;
        private List<VariableHandler.Variable> vars;

        public String getOriginSQL() {
            return this.originSQL;
        }

        public void setOriginSQL(String originSQL) {
            this.originSQL = originSQL;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public List<VariableHandler.Variable> getVars() {
            return this.vars;
        }

        public void setVars(List<VariableHandler.Variable> vars) {
            this.vars = vars;
        }
    }
}

