/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.estodb;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.ConfigSQLExecutor;
import com.frameworkset.common.poolman.SQLExecutor;
import java.util.List;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.estodb.ES2DBDataTran;
import org.frameworkset.elasticsearch.client.estodb.ESExporterScrollHandler;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.scroll.HandlerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESDirectExporterScrollHandler<T>
extends ESExporterScrollHandler<T> {
    private static Logger logger = LoggerFactory.getLogger(ESDirectExporterScrollHandler.class);

    public ESDirectExporterScrollHandler(ImportContext importContext, ConfigSQLExecutor configSQLExecutor, ES2DBDataTran es2DBDataTran) {
        super(importContext, configSQLExecutor, es2DBDataTran);
    }

    @Override
    public void handle(ESDatas<T> response, HandlerInfo handlerInfo) throws Exception {
        long totalSize = response.getTotalSize();
        List datas = response.getDatas();
        int batchNo = this.importContext.getExportCount().increamentCount();
        if (totalSize == 0L || datas == null || datas.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("Igonre Execute export task {}:zero or null datas.", (Object)batchNo);
            }
            return;
        }
        int batchSize = this.importContext.getStoreBatchSize();
        if (logger.isInfoEnabled()) {
            logger.info("Execute task {} start.", (Object)batchNo);
        }
        if (this.es2DBContext.getSql() == null) {
            this.configSQLExecutor.executeBatch(this.importContext.getDbConfig().getDbName(), this.es2DBContext.getSqlName(), datas, batchSize, this.es2DBContext.getBatchHandler());
        } else {
            SQLExecutor.executeBatch((String)this.importContext.getDbConfig().getDbName(), (String)this.es2DBContext.getSql(), (List)datas, (int)batchSize, (BatchHandler)this.es2DBContext.getBatchHandler());
        }
        if (logger.isInfoEnabled()) {
            logger.info("Execute task {} complete and export data {} record.", (Object)batchNo, (Object)datas.size());
        }
    }
}

