/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.estodb;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.estodb.ESExporterScrollHandler;
import org.frameworkset.elasticsearch.client.tran.TranMeta;
import org.frameworkset.elasticsearch.client.tran.TranResultSet;
import org.frameworkset.elasticsearch.client.util.TranUtil;
import org.frameworkset.elasticsearch.entity.ESDatas;

public class ESTranResultSet
implements TranResultSet {
    private Map<String, Object> record;
    private List<Map<String, Object>> records;
    private int pos = 0;
    private int size;
    public static int STATUS_STOP = 1;
    private int status;
    private BlockingQueue<ESDatas> queue = new ArrayBlockingQueue<ESDatas>(10);
    private ImportContext importContext;
    private boolean reachEnd;

    public ESTranResultSet(ImportContext importContext) {
        this.importContext = importContext;
    }

    public void appendData(ESDatas datas, ESExporterScrollHandler exporterScrollHandler) {
        try {
            this.queue.put(datas);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    @Override
    public Object getValue(String colName) throws ESDataImportException {
        return this.record.get(colName);
    }

    @Override
    public Object getValue(String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    @Override
    public Date getDateTimeValue(String colName) throws ESDataImportException {
        Object value = this.getValue(colName);
        if (value == null) {
            return null;
        }
        return TranUtil.getDateTimeValue(colName, value, this.importContext);
    }

    public void stop() {
        this.status = STATUS_STOP;
    }

    public void reachEend() {
        this.reachEnd = true;
    }

    @Override
    public boolean next() throws ESDataImportException {
        if (this.pos < this.size) {
            this.record = this.records.get(this.pos);
            ++this.pos;
            return true;
        }
        if (this.status == STATUS_STOP) {
            return false;
        }
        try {
            ESDatas datas = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
            if (this.status == STATUS_STOP) {
                return false;
            }
            if (datas != null) {
                this.records = datas.getDatas();
                int n = this.size = this.records != null ? this.records.size() : 0;
            }
            if (datas == null || this.size == 0) {
                while (true) {
                    datas = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (this.status == STATUS_STOP) {
                        return false;
                    }
                    if (datas == null) {
                        if (!this.reachEnd) continue;
                        break;
                    }
                    this.records = datas.getDatas();
                    int n = this.size = this.records != null ? this.records.size() : 0;
                    if (this.size > 0) break;
                }
                if (datas == null && this.reachEnd) {
                    return false;
                }
            }
            this.pos = 0;
            this.record = this.records.get(this.pos);
            ++this.pos;
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public TranMeta getMetaData() {
        return null;
    }
}

