/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.metrics;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.frameworkset.elasticsearch.client.metrics.ImportCount;

public class ParallImportCount
extends ImportCount {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();

    @Override
    public long getTotalCount() {
        try {
            this.readLock.lock();
            long l = this.totalCount;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getFailedCount() {
        try {
            this.readLock.lock();
            long l = this.failedCount;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getIgnoreTotalCount() {
        try {
            this.readLock.lock();
            long l = this.ignoreTotalCount;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] increamentFailedCount(long failedCount) {
        try {
            this.writeLock.lock();
            this.failedCount = failedCount + this.failedCount;
            this.totalCount += failedCount;
            long[] lArray = new long[]{this.failedCount, this.totalCount};
            return lArray;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long increamentIgnoreTotalCount() {
        try {
            this.writeLock.lock();
            ++this.ignoreTotalCount;
            ++this.totalCount;
            long l = this.ignoreTotalCount;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getSuccessCount() {
        try {
            this.readLock.lock();
            long l = this.successCount;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] increamentSuccessCount(long successCount) {
        try {
            this.writeLock.lock();
            this.successCount += successCount;
            this.totalCount += successCount;
            long[] lArray = new long[]{this.successCount, this.totalCount};
            return lArray;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

