/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.schedule;

import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.schedule.CallInterceptor;
import org.frameworkset.elasticsearch.client.schedule.ScheduleConfig;
import org.frameworkset.elasticsearch.client.schedule.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleService {
    private static Logger logger = LoggerFactory.getLogger(ScheduleService.class);
    private ImportContext importContext;
    private Timer timer;

    private void scheduleImportData(ImportContext importContext) throws Exception {
        if (!importContext.assertCondition()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Task Assert Execute Condition Failed, Ignore");
            }
            return;
        }
        importContext.doImportData();
    }

    private void preCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        for (CallInterceptor callInterceptor : callInterceptors) {
            try {
                callInterceptor.preCall(taskContext);
            }
            catch (Exception e) {
                logger.error("preCall failed:", (Throwable)e);
            }
        }
    }

    private void afterCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.afterCall(taskContext);
                continue;
            }
            catch (Exception e) {
                logger.error("afterCall failed:", (Throwable)e);
            }
        }
    }

    private void throwException(TaskContext taskContext, Exception e) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.throwException(taskContext, e);
                continue;
            }
            catch (Exception e1) {
                logger.error("afterCall failed:", (Throwable)e1);
            }
        }
    }

    public void timeSchedule(final ImportContext importContext) throws Exception {
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ScheduleService.this.externalTimeSchedule(importContext);
            }
        };
        ScheduleConfig scheduleConfig = importContext.getScheduleConfig();
        Date scheduleDate = scheduleConfig.getScheduleDate();
        Long delay = scheduleConfig.getDeyLay();
        if (scheduleDate != null) {
            if (scheduleConfig.getFixedRate() != null && scheduleConfig.getFixedRate().booleanValue()) {
                this.timer.scheduleAtFixedRate(timerTask, scheduleDate, (long)scheduleConfig.getPeriod());
            } else if (scheduleConfig.getPeriod() != null) {
                this.timer.schedule(timerTask, scheduleDate, (long)scheduleConfig.getPeriod());
            } else {
                this.timer.schedule(timerTask, scheduleDate);
            }
        } else {
            if (delay == null) {
                delay = 1000L;
            }
            if (scheduleConfig.getFixedRate() != null && scheduleConfig.getFixedRate().booleanValue()) {
                this.timer.scheduleAtFixedRate(timerTask, delay, (long)scheduleConfig.getPeriod());
            } else if (scheduleConfig.getPeriod() != null) {
                this.timer.schedule(timerTask, delay, (long)scheduleConfig.getPeriod());
            } else {
                this.timer.schedule(timerTask, delay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void externalTimeSchedule(ImportContext importContext) {
        TaskContext taskContext = new TaskContext(importContext);
        long importStartTime = System.currentTimeMillis();
        try {
            this.preCall(taskContext);
            this.scheduleImportData(importContext);
            this.afterCall(taskContext);
        }
        catch (Exception e) {
            this.throwException(taskContext, e);
            logger.error("scheduleImportData failed:", (Throwable)e);
        }
        finally {
            long importEndTime = System.currentTimeMillis();
            if (importContext != null && this.importContext.isPrintTaskLog() && logger.isInfoEnabled()) {
                logger.info("Execute schedule job Take " + (importEndTime - importStartTime) + " ms");
            }
        }
    }

    public void init(ImportContext importContext) {
        this.importContext = importContext;
    }

    public void stop() {
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }
}

