/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.task;

import java.util.Date;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.client.TranErrorWrapper;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.metrics.ImportCount;
import org.frameworkset.elasticsearch.client.metrics.TaskMetrics;
import org.frameworkset.elasticsearch.client.task.TaskCommand;
import org.frameworkset.elasticsearch.client.task.TaskFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCall
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(TaskCall.class);
    private TranErrorWrapper errorWrapper;
    private ImportContext db2ESImportContext;
    private TaskCommand taskCommand;

    public TaskCall(TaskCommand taskCommand, TranErrorWrapper errorWrapper) {
        this.taskCommand = taskCommand;
        this.errorWrapper = errorWrapper;
        this.db2ESImportContext = taskCommand.getImportContext();
    }

    protected boolean isPrintTaskLog() {
        return this.db2ESImportContext.isPrintTaskLog() && logger.isInfoEnabled();
    }

    public static <DATA, RESULT> RESULT call(TaskCommand<DATA, RESULT> taskCommand) {
        ImportContext importContext = taskCommand.getImportContext();
        ImportCount importCount = taskCommand.getImportCount();
        TaskMetrics taskMetrics = taskCommand.getTaskMetrics();
        taskMetrics.setJobStartTime(importCount.getJobStartTime());
        taskMetrics.setTaskStartTime(new Date());
        try {
            RESULT data = taskCommand.execute();
            long[] metrics = importCount.increamentSuccessCount(taskCommand.getDataSize());
            taskMetrics.setTotalSuccessRecords(metrics[0]);
            taskMetrics.setTotalRecords(metrics[1]);
            taskMetrics.setSuccessRecords(taskCommand.getDataSize());
            taskMetrics.setTaskEndTime(new Date());
            if (importContext.getExportResultHandler() != null) {
                try {
                    importContext.getExportResultHandler().handleResult(taskCommand, data);
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
            return data;
        }
        catch (ElasticSearchException e) {
            long[] metrics = importCount.increamentFailedCount(taskCommand.getDataSize());
            taskMetrics.setFailedRecords(taskCommand.getDataSize());
            taskMetrics.setTotalRecords(metrics[1]);
            taskMetrics.setTotalFailedRecords(metrics[0]);
            taskMetrics.setTaskEndTime(new Date());
            if (importContext.getExportResultHandler() != null) {
                try {
                    importContext.getExportResultHandler().handleException(taskCommand, (Exception)((Object)e));
                }
                catch (Exception ee) {
                    logger.warn("", (Throwable)e);
                }
            }
            throw e;
        }
        catch (Exception e) {
            long[] metrics = importCount.increamentFailedCount(taskCommand.getDataSize());
            taskMetrics.setFailedRecords(taskCommand.getDataSize());
            taskMetrics.setTotalRecords(metrics[1]);
            taskMetrics.setTotalFailedRecords(metrics[0]);
            taskMetrics.setTaskEndTime(new Date());
            if (importContext.getExportResultHandler() != null) {
                try {
                    importContext.getExportResultHandler().handleException(taskCommand, e);
                }
                catch (Exception ee) {
                    logger.warn("", (Throwable)e);
                }
            }
            throw new ElasticSearchException((Throwable)e);
        }
    }

    @Override
    public void run() {
        block9: {
            if (!this.errorWrapper.assertCondition()) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Task[" + this.taskCommand.getTaskNo() + "] Assert Execute Condition Failed, Ignore");
                }
                return;
            }
            long start = System.currentTimeMillis();
            StringBuilder info = null;
            if (this.isPrintTaskLog()) {
                info = new StringBuilder();
            }
            try {
                if (this.isPrintTaskLog()) {
                    info.append("Task[").append(this.taskCommand.getTaskNo()).append("] starting ......");
                    logger.info(info.toString());
                }
                TaskCall.call(this.taskCommand);
                if (this.isPrintTaskLog()) {
                    long end = System.currentTimeMillis();
                    info.setLength(0);
                    info.append("Task[").append(this.taskCommand.getTaskNo()).append("] finish,import ").append(this.taskCommand.getDataSize()).append(" records,Total import ").append(this.taskCommand.getTaskMetrics().getTotalSuccessRecords()).append(" records,Take time:").append(end - start).append("ms");
                    logger.info(info.toString());
                }
            }
            catch (Exception e) {
                this.errorWrapper.setError(e);
                if (!this.db2ESImportContext.isContinueOnError()) {
                    if (this.isPrintTaskLog()) {
                        long end = System.currentTimeMillis();
                        info.setLength(0);
                        info.append("Task[").append(this.taskCommand.getTaskNo()).append("] failed: ").append(this.taskCommand.getDataSize()).append(" records, Take time:").append(end - start).append("ms");
                        logger.info(info.toString());
                    }
                    throw new TaskFailedException("Task[" + this.taskCommand.getTaskNo() + "] Execute Failed: " + this.taskCommand.getDataSize() + " records,", e);
                }
                if (!this.isPrintTaskLog()) break block9;
                long end = System.currentTimeMillis();
                info.setLength(0);
                info.append("Task[").append(this.taskCommand.getTaskNo()).append("] failed: ").append(this.taskCommand.getDataSize()).append(" records,but continue On Error! Take time:").append(end - start).append("ms");
                logger.info(info.toString(), (Throwable)e);
            }
        }
    }
}

