/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.tran;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.TranErrorWrapper;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.metrics.ImportCount;
import org.frameworkset.elasticsearch.client.tran.DataTran;
import org.frameworkset.elasticsearch.client.tran.TranResultSet;
import org.frameworkset.elasticsearch.scroll.BreakableScrollHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataTran
implements DataTran {
    private static Logger logger = LoggerFactory.getLogger(BaseDataTran.class);
    protected static Object dummy = new Object();
    protected ImportContext importContext;
    protected TranResultSet jdbcResultSet;
    private CountDownLatch countDownLatch;
    private BreakableScrollHandler breakableScrollHandler;
    public static final Class[] basePrimaryTypes = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Float.TYPE, Short.TYPE, Double.TYPE, Character.TYPE, Byte.TYPE, BigInteger.class, BigDecimal.class};

    @Override
    public BreakableScrollHandler getBreakableScrollHandler() {
        return this.breakableScrollHandler;
    }

    public void setBreakableScrollHandler(BreakableScrollHandler breakableScrollHandler) {
        this.breakableScrollHandler = breakableScrollHandler;
    }

    public BaseDataTran(TranResultSet jdbcResultSet, ImportContext importContext) {
        this.jdbcResultSet = jdbcResultSet;
        this.importContext = importContext;
        this.init();
    }

    public BaseDataTran(TranResultSet jdbcResultSet, ImportContext importContext, CountDownLatch countDownLatch) {
        this.jdbcResultSet = jdbcResultSet;
        this.importContext = importContext;
        this.countDownLatch = countDownLatch;
        this.init();
    }

    protected void init() {
    }

    protected void stop() {
        if (this.breakableScrollHandler != null) {
            this.breakableScrollHandler.setBreaked(true);
        }
        this.importContext.stop();
    }

    public abstract void logTaskStart(Logger var1);

    public String tran() throws ESDataImportException {
        try {
            if (this.jdbcResultSet == null) {
                String string = null;
                return string;
            }
            if (this.isPrintTaskLog()) {
                this.logTaskStart(logger);
            }
            if (this.importContext.getStoreBatchSize() <= 0) {
                String string = this.serialExecute();
                return string;
            }
            if (this.importContext.getThreadCount() > 0 && this.importContext.isParallel()) {
                String string = this.parallelBatchExecute();
                return string;
            }
            String string = this.batchExecute();
            return string;
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
    }

    protected void jobComplete(ExecutorService service, Exception exception, Object lastValue, TranErrorWrapper tranErrorWrapper) {
        if (this.importContext.getScheduleService() == null) {
            service.shutdown();
        } else if (tranErrorWrapper.assertCondition(exception)) {
            this.importContext.flushLastValue(lastValue);
        } else {
            service.shutdown();
            this.stop();
        }
    }

    protected boolean isPrintTaskLog() {
        return this.importContext.isPrintTaskLog() && logger.isInfoEnabled();
    }

    @Override
    public void waitTasksComplete(final List<Future> tasks, final ExecutorService service, Exception exception, Object lastValue, final ImportCount totalCount, final TranErrorWrapper tranErrorWrapper) {
        if (!this.importContext.isAsyn() || this.importContext.getScheduleService() != null) {
            int count = 0;
            for (Future future : tasks) {
                try {
                    future.get();
                    ++count;
                }
                catch (ExecutionException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    if (!logger.isErrorEnabled()) continue;
                    if (e.getCause() != null) {
                        logger.error("", e.getCause());
                        continue;
                    }
                    logger.error("", (Throwable)e);
                }
                catch (Exception e) {
                    if (exception == null) {
                        exception = e;
                    }
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("", (Throwable)e);
                }
            }
            totalCount.setJobEndTime(new Date());
            if (this.isPrintTaskLog()) {
                logger.info("Complete tasks:" + count + ",Total success import " + totalCount.getSuccessCount() + " records,Ignore Total " + totalCount.getIgnoreTotalCount() + " records,failed total" + totalCount.getFailedCount() + " records.");
            }
            this.jobComplete(service, exception, lastValue, tranErrorWrapper);
            totalCount.setJobEndTime(new Date());
        } else {
            Thread completeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int count = 0;
                    for (Future future : tasks) {
                        try {
                            future.get();
                            ++count;
                        }
                        catch (ExecutionException e) {
                            if (!logger.isErrorEnabled()) continue;
                            if (e.getCause() != null) {
                                logger.error("", e.getCause());
                                continue;
                            }
                            logger.error("", (Throwable)e);
                        }
                        catch (Exception e) {
                            if (!logger.isErrorEnabled()) continue;
                            logger.error("", (Throwable)e);
                        }
                    }
                    if (BaseDataTran.this.isPrintTaskLog()) {
                        logger.info("Complete tasks:" + count + ",Total success import " + totalCount.getSuccessCount() + " records,Ignore Total " + totalCount.getIgnoreTotalCount() + " records,failed total" + totalCount.getFailedCount() + " records.");
                    }
                    BaseDataTran.this.jobComplete(service, null, null, tranErrorWrapper);
                    totalCount.setJobEndTime(new Date());
                }
            });
            completeThread.start();
        }
    }

    public static boolean isBasePrimaryType(Class type) {
        if (!type.isArray()) {
            if (type.isEnum()) {
                return true;
            }
            for (Class primaryType : basePrimaryTypes) {
                if (!primaryType.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Object getLastValue() throws ESDataImportException {
        if (this.importContext.getLastValueClumnName() == null) {
            return null;
        }
        try {
            if (this.importContext.getLastValueType() == null || this.importContext.getLastValueType() == 0) {
                return this.jdbcResultSet.getValue(this.importContext.getLastValueClumnName());
            }
            if (this.importContext.getLastValueType() == 1) {
                return this.jdbcResultSet.getDateTimeValue(this.importContext.getLastValueClumnName());
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
        return null;
    }
}

