/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.tran;

import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.TranErrorWrapper;
import org.frameworkset.elasticsearch.client.context.Context;
import org.frameworkset.elasticsearch.client.context.ContextImpl;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.client.db2es.JDBCGetVariableValue;
import org.frameworkset.elasticsearch.client.db2es.TaskCommandImpl;
import org.frameworkset.elasticsearch.client.metrics.ImportCount;
import org.frameworkset.elasticsearch.client.metrics.ParallImportCount;
import org.frameworkset.elasticsearch.client.metrics.SerialImportCount;
import org.frameworkset.elasticsearch.client.schedule.Status;
import org.frameworkset.elasticsearch.client.task.TaskCall;
import org.frameworkset.elasticsearch.client.tran.BaseDataTran;
import org.frameworkset.elasticsearch.client.tran.TranMeta;
import org.frameworkset.elasticsearch.client.tran.TranResultSet;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseElasticsearchDataTran
extends BaseDataTran {
    private static Logger logger = LoggerFactory.getLogger(BaseElasticsearchDataTran.class);
    private ClientInterface clientInterface;
    public static final Class[] basePrimaryTypes = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Float.TYPE, Short.TYPE, Double.TYPE, Character.TYPE, Byte.TYPE, BigInteger.class, BigDecimal.class};

    @Override
    public void logTaskStart(Logger logger) {
        logger.info("import data to IndexName[" + this.importContext.getEsIndexWrapper().getIndex() + "] IndexType[" + this.importContext.getEsIndexWrapper().getType() + "] start.");
    }

    public BaseElasticsearchDataTran(TranResultSet jdbcResultSet, ImportContext importContext) {
        super(jdbcResultSet, importContext);
        this.clientInterface = ElasticSearchHelper.getRestClientUtil();
    }

    public BaseElasticsearchDataTran(TranResultSet jdbcResultSet, ImportContext importContext, String esCluster) {
        super(jdbcResultSet, importContext);
        this.clientInterface = ElasticSearchHelper.getRestClientUtil((String)esCluster);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute() {
        TranErrorWrapper tranErrorWrapper;
        Object lastValue;
        Throwable exception;
        ParallImportCount totalCount;
        ArrayList<Future> tasks;
        ExecutorService service;
        String ret;
        BBossStringWriter writer;
        block16: {
            int count = 0;
            StringBuilder builder = new StringBuilder();
            writer = new BBossStringWriter(builder);
            ret = null;
            service = this.importContext.buildThreadPool();
            tasks = new ArrayList<Future>();
            int taskNo = 0;
            totalCount = new ParallImportCount();
            exception = null;
            Status currentStatus = this.importContext.getCurrentStatus();
            Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
            lastValue = null;
            tranErrorWrapper = new TranErrorWrapper(this.importContext);
            int batchsize = this.importContext.getStoreBatchSize();
            try {
                BatchContext batchContext = new BatchContext();
                while (this.jdbcResultSet.next()) {
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    ContextImpl context = new ContextImpl(this.importContext, this.jdbcResultSet, batchContext);
                    context.refactorData();
                    if (context.isDrop()) continue;
                    BaseElasticsearchDataTran.evalBuilk(this.jdbcResultSet, batchContext, (Writer)writer, context, "index", this.clientInterface.isVersionUpper7());
                    if (++count != batchsize) continue;
                    writer.flush();
                    String datas = builder.toString();
                    builder.setLength(0);
                    writer.close();
                    writer = new BBossStringWriter(builder);
                    count = 0;
                    TaskCommandImpl taskCommand = new TaskCommandImpl(totalCount, this.importContext, batchsize, ++taskNo, totalCount.getJobNo());
                    taskCommand.setClientInterface(this.clientInterface);
                    taskCommand.setRefreshOption(this.importContext.getRefreshOption());
                    taskCommand.setDatas(datas);
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                }
                if (count > 0) {
                    if (!tranErrorWrapper.assertCondition()) {
                        tranErrorWrapper.throwError();
                    }
                    writer.flush();
                    String datas = builder.toString();
                    TaskCommandImpl taskCommand = new TaskCommandImpl(totalCount, this.importContext, count, ++taskNo, totalCount.getJobNo());
                    taskCommand.setClientInterface(this.clientInterface);
                    taskCommand.setRefreshOption(this.importContext.getRefreshOption());
                    taskCommand.setDatas(datas);
                    tasks.add(service.submit(new TaskCall(taskCommand, tranErrorWrapper)));
                    if (this.isPrintTaskLog()) {
                        logger.info("submit tasks:" + taskNo);
                    }
                    break block16;
                }
                if (this.isPrintTaskLog()) {
                    logger.info("submit tasks:" + taskNo);
                }
            }
            catch (SQLException e) {
                try {
                    exception = e;
                    throw new ElasticSearchException((Throwable)e);
                    catch (ElasticSearchException e2) {
                        exception = e2;
                        throw e2;
                    }
                    catch (Exception e3) {
                        exception = e3;
                        throw new ElasticSearchException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper);
                    try {
                        writer.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    totalCount.setJobEndTime(new Date());
                    throw throwable;
                }
            }
        }
        this.waitTasksComplete(tasks, service, (Exception)exception, lastValue, totalCount, tranErrorWrapper);
        try {
            writer.close();
        }
        catch (Exception batchContext) {
            // empty catch block
        }
        totalCount.setJobEndTime(new Date());
        return ret;
    }

    @Override
    public String batchExecute() {
        int count = 0;
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        String ret = null;
        int taskNo = 0;
        Throwable exception = null;
        Status currentStatus = this.importContext.getCurrentStatus();
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        Object lastValue = null;
        long start = System.currentTimeMillis();
        long istart = 0L;
        long end = 0L;
        long totalCount = 0L;
        long ignoreTotalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        int batchsize = this.importContext.getStoreBatchSize();
        String refreshOption = this.importContext.getRefreshOption();
        try {
            istart = start;
            BatchContext batchContext = new BatchContext();
            while (this.jdbcResultSet.next()) {
                lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                ContextImpl context = new ContextImpl(this.importContext, this.jdbcResultSet, batchContext);
                context.refactorData();
                if (context.isDrop()) {
                    ((ImportCount)importCount).increamentIgnoreTotalCount();
                    continue;
                }
                BaseElasticsearchDataTran.evalBuilk(this.jdbcResultSet, batchContext, (Writer)writer, context, "index", this.clientInterface.isVersionUpper7());
                if (++count != batchsize) continue;
                writer.flush();
                String datas = builder.toString();
                builder.setLength(0);
                writer.close();
                writer = new BBossStringWriter(builder);
                count = 0;
                TaskCommandImpl taskCommand = new TaskCommandImpl(importCount, this.importContext, batchsize, ++taskNo, importCount.getJobNo());
                taskCommand.setClientInterface(this.clientInterface);
                taskCommand.setRefreshOption(refreshOption);
                taskCommand.setDatas(datas);
                ret = TaskCall.call(taskCommand);
                this.importContext.flushLastValue(lastValue);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    logger.info("Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + batchsize + " records.");
                    istart = end;
                }
                totalCount += (long)batchsize;
            }
            if (count > 0) {
                writer.flush();
                String datas = builder.toString();
                TaskCommandImpl taskCommand = new TaskCommandImpl(importCount, this.importContext, count, ++taskNo, importCount.getJobNo());
                taskCommand.setClientInterface(this.clientInterface);
                taskCommand.setRefreshOption(refreshOption);
                taskCommand.setDatas(datas);
                ret = TaskCall.call(taskCommand);
                this.importContext.flushLastValue(lastValue);
                if (this.isPrintTaskLog()) {
                    end = System.currentTimeMillis();
                    logger.info("Task[" + taskNo + "] complete,take time:" + (end - istart) + "ms" + ",import " + count + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
                }
                totalCount += (long)count;
            }
            if (this.isPrintTaskLog()) {
                end = System.currentTimeMillis();
                logger.info("Execute Tasks:" + taskNo + ",All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
        }
        catch (SQLException e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition((Exception)exception, this.importContext)) {
                this.stop();
            }
            try {
                writer.close();
            }
            catch (Exception exception2) {}
            importCount.setJobEndTime(new Date());
        }
        return ret;
    }

    @Override
    public String serialExecute() {
        String refreshOption = this.importContext.getRefreshOption();
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        Object lastValue = null;
        Throwable exception = null;
        long start = System.currentTimeMillis();
        Status currentStatus = this.importContext.getCurrentStatus();
        Object currentValue = currentStatus != null ? currentStatus.getLastValue() : null;
        long totalCount = 0L;
        SerialImportCount importCount = new SerialImportCount();
        long ignoreTotalCount = 0L;
        try {
            BatchContext batchContext = new BatchContext();
            while (this.jdbcResultSet.next()) {
                try {
                    lastValue = lastValue == null ? this.importContext.max(currentValue, this.getLastValue()) : this.importContext.max(lastValue, this.getLastValue());
                    ContextImpl context = new ContextImpl(this.importContext, this.jdbcResultSet, batchContext);
                    context.refactorData();
                    if (context.isDrop()) {
                        ((ImportCount)importCount).increamentIgnoreTotalCount();
                        continue;
                    }
                    BaseElasticsearchDataTran.evalBuilk(this.jdbcResultSet, batchContext, (Writer)writer, context, "index", this.clientInterface.isVersionUpper7());
                    ++totalCount;
                }
                catch (Exception e) {
                    throw new ElasticSearchException((Throwable)e);
                }
            }
            writer.flush();
            String ret = null;
            if (builder.length() > 0) {
                TaskCommandImpl taskCommand = new TaskCommandImpl(importCount, this.importContext, totalCount, 1, importCount.getJobNo());
                taskCommand.setClientInterface(this.clientInterface);
                taskCommand.setRefreshOption(refreshOption);
                taskCommand.setDatas(builder.toString());
                ret = TaskCall.call(taskCommand);
            } else {
                ret = "{\"took\":0,\"errors\":false}";
            }
            this.importContext.flushLastValue(lastValue);
            if (this.isPrintTaskLog()) {
                long end = System.currentTimeMillis();
                logger.info("All Take time:" + (end - start) + "ms" + ",Import total " + totalCount + " records,IgnoreTotalCount " + ignoreTotalCount + " records.");
            }
            String string = ret;
            return string;
        }
        catch (ElasticSearchException e) {
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            if (!TranErrorWrapper.assertCondition((Exception)exception, this.importContext)) {
                this.stop();
            }
            importCount.setJobEndTime(new Date());
        }
    }

    public String tran(String indexName, String indexType) throws ElasticSearchException {
        ESIndexWrapper esIndexWrapper = new ESIndexWrapper(indexName, indexType);
        this.importContext.setEsIndexWrapper(esIndexWrapper);
        return this.tran();
    }

    public static void buildMeta(Context context, Writer writer, String action, boolean upper7) throws Exception {
        Object id = context.getEsId();
        Object parentId = context.getParentId();
        Object routing = context.getRouting();
        Object esRetryOnConflict = context.getEsRetryOnConflict();
        BaseElasticsearchDataTran.buildMeta(context, writer, action, id, parentId, routing, esRetryOnConflict, upper7);
    }

    public static void buildMeta(Context context, Writer writer, String action, Object id, Object parentId, Object routing, Object esRetryOnConflict, boolean upper7) throws Exception {
        ESIndexWrapper esIndexWrapper = context.getESIndexWrapper();
        JDBCGetVariableValue jdbcGetVariableValue = new JDBCGetVariableValue(context);
        if (id != null) {
            Object versionType;
            Object version;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            if (esIndexWrapper == null) {
                throw new ESDataImportException(" ESIndex not seted.");
            }
            BuildTool.buildIndiceName((ESIndexWrapper)esIndexWrapper, (Writer)writer, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
            writer.write("\"");
            if (!upper7) {
                writer.write(", \"_type\" : \"");
                if (esIndexWrapper == null) {
                    throw new ESDataImportException(" ESIndex type not seted.");
                }
                BuildTool.buildIndiceType((ESIndexWrapper)esIndexWrapper, (Writer)writer, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
                writer.write("\"");
            }
            writer.write(", \"_id\" : ");
            BuildTool.buildId((Object)id, (Writer)writer, (boolean)true);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
            }
            if (routing != null) {
                if (!upper7) {
                    writer.write(", \"_routing\" : ");
                } else {
                    writer.write(", \"routing\" : ");
                }
                BuildTool.buildId((Object)routing, (Writer)writer, (boolean)true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((version = context.getVersion()) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((versionType = context.getEsVersionType()) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write(" } }\n");
        } else {
            Object versionType;
            Object version;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            if (esIndexWrapper == null) {
                throw new ESDataImportException(" ESIndex not seted.");
            }
            BuildTool.buildIndiceName((ESIndexWrapper)esIndexWrapper, (Writer)writer, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
            writer.write("\"");
            if (!upper7) {
                writer.write(", \"_type\" : \"");
                if (esIndexWrapper == null) {
                    throw new ESDataImportException(" ESIndex type not seted.");
                }
                BuildTool.buildIndiceType((ESIndexWrapper)esIndexWrapper, (Writer)writer, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
                writer.write("\"");
            }
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
            }
            if (routing != null) {
                if (!upper7) {
                    writer.write(", \"_routing\" : ");
                } else {
                    writer.write(", \"routing\" : ");
                }
                BuildTool.buildId((Object)routing, (Writer)writer, (boolean)true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((version = context.getVersion()) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((versionType = context.getEsVersionType()) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write(" } }\n");
        }
    }

    public static void evalBuilk(TranResultSet jdbcResultSet, BatchContext batchContext, Writer writer, Context context, String action, boolean upper7) throws Exception {
        BaseElasticsearchDataTran.buildMeta(context, writer, action, upper7);
        if (!action.equals("update")) {
            BaseElasticsearchDataTran.serialResult(writer, context);
        } else {
            writer.write("{\"doc\":");
            BaseElasticsearchDataTran.serialResult(writer, context);
            if (context.getEsDocAsUpsert() != null) {
                writer.write(",\"doc_as_upsert\":");
                writer.write(String.valueOf(context.getEsDocAsUpsert()));
            }
            if (context.getEsReturnSource() != null) {
                writer.write(",\"_source\":");
                writer.write(String.valueOf(context.getEsReturnSource()));
            }
            writer.write("}\n");
        }
    }

    private static void serialResult(Writer writer, Context context) throws Exception {
        TranMeta metaData = context.getMetaData();
        int counts = metaData.getColumnCount();
        writer.write("{");
        Boolean useJavaName = context.getUseJavaName();
        if (useJavaName == null) {
            useJavaName = true;
        }
        Boolean useLowcase = context.getUseLowcase();
        if (useJavaName == null) {
            useJavaName = false;
        }
        if (useLowcase == null) {
            useLowcase = false;
        }
        boolean hasSeted = false;
        HashMap<String, Object> addedFields = new HashMap<String, Object>();
        List<FieldMeta> fieldValueMetas = context.getFieldValues();
        hasSeted = BaseElasticsearchDataTran.appendFieldValues(writer, context, fieldValueMetas, hasSeted, addedFields);
        fieldValueMetas = context.getESJDBCFieldValues();
        hasSeted = BaseElasticsearchDataTran.appendFieldValues(writer, context, fieldValueMetas, hasSeted, addedFields);
        for (int i = 0; i < counts; ++i) {
            String colName = metaData.getColumnLabelByIndex(i);
            int sqlType = metaData.getColumnTypeByIndex(i);
            String javaName = null;
            FieldMeta fieldMeta = context.getMappingName(colName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                javaName = fieldMeta.getEsFieldName();
            } else if (useJavaName.booleanValue()) {
                javaName = metaData.getColumnJavaNameByIndex(i);
            } else {
                String string = javaName = useLowcase == false ? colName : metaData.getColumnLabelLowerByIndex(i);
            }
            if (javaName == null) {
                javaName = colName;
            }
            if (addedFields.containsKey(javaName)) continue;
            if (hasSeted) {
                writer.write(",");
            } else {
                hasSeted = true;
            }
            writer.write("\"");
            writer.write(javaName);
            writer.write("\":");
            Object value = context.getValue(i, colName, sqlType);
            if (value != null) {
                CharEscapeUtil charEscapeUtil;
                String dataStr;
                if (value instanceof String) {
                    writer.write("\"");
                    CharEscapeUtil charEscapeUtil2 = new CharEscapeUtil(writer);
                    charEscapeUtil2.writeString((String)value, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Date) {
                    DateFormateMeta dateFormateMeta;
                    DateFormat dateFormat = null;
                    if (fieldMeta != null && (dateFormateMeta = fieldMeta.getDateFormateMeta()) != null) {
                        dateFormat = dateFormateMeta.toDateFormat();
                    }
                    if (dateFormat == null) {
                        dateFormat = context.getDateFormat();
                    }
                    String dataStr2 = ESUtil.getDate((Date)((Date)value), (DateFormat)dateFormat);
                    writer.write("\"");
                    writer.write(dataStr2);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Clob) {
                    dataStr = ValueExchange.getStringFromClob((Clob)((Clob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Blob) {
                    dataStr = ValueExchange.getStringFromBlob((Blob)((Blob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                SimpleStringUtil.object2json((Object)value, (Writer)writer);
                continue;
            }
            writer.write("null");
        }
        writer.write("}\n");
    }

    private static boolean appendFieldValues(Writer writer, Context context, List<FieldMeta> fieldValueMetas, boolean hasSeted, Map<String, Object> addedFields) throws IOException {
        if (fieldValueMetas != null && fieldValueMetas.size() > 0) {
            for (int i = 0; i < fieldValueMetas.size(); ++i) {
                FieldMeta fieldMeta = fieldValueMetas.get(i);
                String javaName = fieldMeta.getEsFieldName();
                if (addedFields.containsKey(javaName)) {
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("Ignore adding duplicate field[" + javaName + "] value[" + fieldMeta.getValue() + "].");
                    continue;
                }
                Object value = fieldMeta.getValue();
                if (hasSeted) {
                    writer.write(",");
                } else {
                    hasSeted = true;
                }
                writer.write("\"");
                writer.write(javaName);
                writer.write("\":");
                if (value != null) {
                    if (value instanceof String) {
                        writer.write("\"");
                        CharEscapeUtil charEscapeUtil = new CharEscapeUtil(writer);
                        charEscapeUtil.writeString((String)value, true);
                        writer.write("\"");
                    } else if (value instanceof Date) {
                        DateFormateMeta dateFormateMeta;
                        DateFormat dateFormat = null;
                        if (fieldMeta != null && (dateFormateMeta = fieldMeta.getDateFormateMeta()) != null) {
                            dateFormat = dateFormateMeta.toDateFormat();
                        }
                        if (dateFormat == null) {
                            dateFormat = context.getDateFormat();
                        }
                        String dataStr = ESUtil.getDate((Date)((Date)value), (DateFormat)dateFormat);
                        writer.write("\"");
                        writer.write(dataStr);
                        writer.write("\"");
                    } else if (BaseElasticsearchDataTran.isBasePrimaryType(value.getClass())) {
                        writer.write(String.valueOf(value));
                    } else {
                        SimpleStringUtil.object2json((Object)value, (Writer)writer);
                    }
                } else {
                    writer.write("null");
                }
                addedFields.put(javaName, dummy);
            }
        }
        return hasSeted;
    }

    public static boolean isBasePrimaryType(Class type) {
        if (!type.isArray()) {
            if (type.isEnum()) {
                return true;
            }
            for (Class primaryType : basePrimaryTypes) {
                if (!primaryType.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

