/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.context.ImportContext;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.util.annotations.DateFormateMeta;

public abstract class TranUtil {
    public static Date getDateTimeValue(String colName, Object value, ImportContext importContext) throws ESDataImportException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String) {
            DateFormat dateFormat = null;
            if (importContext.getDateFormat() != null) {
                DateFormateMeta dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)importContext.getDateFormat(), (String)importContext.getLocale(), (String)importContext.getTimeZone());
                dateFormat = dateFormateMeta.toDateFormat();
            } else {
                dateFormat = SerialUtil.getDateFormateMeta().toDateFormat();
            }
            try {
                return dateFormat.parse((String)value);
            }
            catch (ParseException e) {
                throw new ESDataImportException("Illegment colName[" + colName + "] date value:" + (String)value, e);
            }
        }
        throw new ESDataImportException("Illegment colName[" + colName + "] date value:" + (String)value);
    }
}

