/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.codec.Base64;
import cpcn.dsp.institution.api.security.SecurityUtil;
import cpcn.dsp.institution.api.system.CodeException;
import cpcn.dsp.institution.api.util.LogType;
import cpcn.dsp.institution.api.util.Loggerx;
import cpcn.dsp.institution.api.util.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.HashMap;

public final class EncryptPasswordUtil {
    private static Loggerx logger = Loggerx.getLogger("system");
    private static final byte[] MASKCODE = new byte[]{-28, -72, -83, -23, -121, -111, -26, -108, -81, -28, -69, -104, -26, -100, -119, -23, -103, -112, -27, -123, -84, -27, -113, -72};

    private EncryptPasswordUtil() {
    }

    public static String encryptPassword(String password) throws Exception {
        SecureRandom random = new SecureRandom();
        String sRand = "";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            String rand = String.valueOf(random.nextInt(10));
            sb.append(rand);
        }
        sRand = sb.toString();
        byte[] passwordBT = StringUtil.hex2bytes(password);
        byte[] tempPasswordBT = StringUtil.byteConcat(sRand.getBytes(), passwordBT);
        return EncryptPasswordUtil.byteXORbyteTo24Hex(tempPasswordBT);
    }

    public static String decryptRSAToString(String password, PrivateKey privateKey) throws CodeException {
        byte[] p = SecurityUtil.decryptRSAToByte(password, privateKey);
        if (null == p) {
            throw new CodeException("2001", "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef\u3002");
        }
        return StringUtil.bytes2hex(p);
    }

    public static byte[] decryptRSAToByte(String password, PrivateKey privateKey) throws CodeException {
        byte[] p = SecurityUtil.decryptRSAToByte(password, privateKey);
        if (null == p) {
            throw new CodeException("2001", "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef\u3002");
        }
        return p;
    }

    public static String byteXORbyteTo24Hex(byte[] pwd) throws CodeException {
        byte[] b = EncryptPasswordUtil.byteXORbyteToByte(pwd, 0);
        return StringUtil.bytes2hex(b);
    }

    public static String byteXORbyteTo20Hex(byte[] pwd) throws CodeException {
        byte[] b = EncryptPasswordUtil.byteXORbyteToByte(pwd, 4);
        return StringUtil.bytes2hex(b);
    }

    public static byte[] byteXORbyteToByte(byte[] pwd, int startPosition) throws CodeException {
        if (null == pwd || pwd.length == 0) {
            throw new CodeException("", "\u5bc6\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int pLen = pwd.length;
        if (pLen != MASKCODE.length) {
            throw new CodeException("", "\u5bc6\u6587\u548c\u63a9\u7801\u957f\u5ea6\u4e0d\u5339\u914d");
        }
        if (MASKCODE.length != 24) {
            throw new CodeException("", "\u63a9\u7801\u957f\u5ea6\u4e0d\u8db3");
        }
        if (startPosition < 0) {
            throw new CodeException("", "\u8c03\u6574\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (startPosition > pLen) {
            throw new CodeException("", "\u8c03\u6574\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e\u5bc6\u6587\u957f\u5ea6");
        }
        byte[] temp = StringUtil.byteXORbyte(pwd, MASKCODE);
        if (null == temp || temp.length == 0) {
            throw new CodeException("", "\u5f02\u6216\u8ba1\u7b97\u5931\u8d25");
        }
        byte[] byteXOR = new byte[temp.length - startPosition];
        for (int i = startPosition; i < temp.length; ++i) {
            byteXOR[i - startPosition] = temp[i];
        }
        return byteXOR;
    }

    public static boolean comparePassword(String password, String pwdFromDB, PrivateKey privateKey) throws CodeException {
        String pwdFromIE = EncryptPasswordUtil.decryptRSAToString(password, privateKey);
        String pwdFromDBXor = EncryptPasswordUtil.byteXORbyteTo20Hex(StringUtil.hex2bytes(pwdFromDB));
        return pwdFromIE.equals(pwdFromDBXor);
    }

    public static boolean compareDESPassword(String password, String pwdFromDB, PrivateKey privateKey) throws CodeException {
        try {
            String pwdFromIE = EncryptPasswordUtil.decryptPasswordWithH5EdtionHex(password, privateKey);
            String pwdFromDBXor = EncryptPasswordUtil.byteXORbyteTo20Hex(StringUtil.hex2bytes(pwdFromDB));
            return pwdFromIE.equals(pwdFromDBXor);
        }
        catch (Exception e) {
            logger.error(LogType.ERROR, e.getMessage(), e);
            return false;
        }
    }

    public static String decryptPasswordWithH5EdtionHex(String password, PrivateKey privateKey) throws CodeException {
        JSONObject json = JSONObject.parseObject((String)password);
        String passwordFromMap = json.getString("password");
        String clientRandomString = json.getString("clientRandomString");
        String serverRandomString = json.getString("serverRandomString");
        byte[] rsData = Base64.decode(serverRandomString);
        byte[] rcData = EncryptPasswordUtil.decryptRSAToByte(clientRandomString, privateKey);
        byte[] keyData = new byte[24];
        byte[] ivData = new byte[8];
        System.arraycopy(rsData, 0, keyData, 0, 12);
        System.arraycopy(rcData, 0, keyData, 12, 12);
        System.arraycopy(rsData, 12, ivData, 0, 4);
        System.arraycopy(rcData, 12, ivData, 4, 4);
        byte[] plainPWDBinary = SecurityUtil.des3CBCDecrypt(ivData, keyData, Base64.decode(passwordFromMap));
        String plainPWD = new String(plainPWDBinary);
        return StringUtil.trim(EncryptPasswordUtil.bytes2Hex(Base64.decode(plainPWD)).toUpperCase());
    }

    public static String decryptPasswordWithH5EdtionOri(String password, PrivateKey privateKey) throws CodeException {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] array = password.substring(1, password.length() - 1).split(",");
        for (int i = 0; i < array.length; ++i) {
            map.put(array[i].split(":")[0], array[i].split(":")[1]);
        }
        String passwordFromMap = (String)map.get("password");
        String clientRandomString = (String)map.get("clientRandomString");
        String serverRandomString = (String)map.get("serverRandomString");
        byte[] rsData = Base64.decode(serverRandomString);
        byte[] rcData = EncryptPasswordUtil.decryptRSAToByte(clientRandomString, privateKey);
        byte[] keyData = new byte[24];
        byte[] ivData = new byte[8];
        System.arraycopy(rsData, 0, keyData, 0, 12);
        System.arraycopy(rcData, 0, keyData, 12, 12);
        System.arraycopy(rsData, 12, ivData, 0, 4);
        System.arraycopy(rcData, 12, ivData, 4, 4);
        byte[] plainPWDBinary = SecurityUtil.des3CBCDecrypt(ivData, keyData, Base64.decode(passwordFromMap));
        String plainPWD = new String(plainPWDBinary);
        return StringUtil.trim(EncryptPasswordUtil.encrypt(plainPWD)).toUpperCase();
    }

    public static String encrypt(String strSrc) {
        MessageDigest md = null;
        String strDes = null;
        byte[] bt = strSrc.getBytes();
        try {
            md = MessageDigest.getInstance("SHA-1");
            md.update(bt);
            strDes = EncryptPasswordUtil.bytes2Hex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(LogType.ERROR, e.getMessage(), e);
            return null;
        }
        return strDes;
    }

    public static String bytes2Hex(byte[] bts) {
        StringBuilder des = new StringBuilder();
        String tmp = null;
        for (int i = 0; i < bts.length; ++i) {
            tmp = Integer.toHexString(bts[i] & 0xFF);
            if (tmp.length() == 1) {
                des.append("0");
            }
            des.append(tmp);
        }
        return des.toString();
    }
}

